/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.metadata.pipeline;

import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;
import net.shibboleth.metadata.Item;
import net.shibboleth.metadata.pipeline.AbstractStage;
import net.shibboleth.metadata.pipeline.StageProcessingException;
import net.shibboleth.shared.annotation.constraint.NonnullElements;
import net.shibboleth.shared.annotation.constraint.Unmodifiable;
import net.shibboleth.shared.collection.CollectionSupport;

@ThreadSafe
public class StaticItemSourceStage<T>
extends AbstractStage<T> {
    @Nonnull
    @NonnullElements
    @Unmodifiable
    @GuardedBy(value="this")
    private List<Item<T>> source = CollectionSupport.emptyList();

    @Nonnull
    @NonnullElements
    @Unmodifiable
    public final synchronized List<Item<T>> getSourceItems() {
        return this.source;
    }

    public synchronized void setSourceItems(@Nonnull @NonnullElements @Unmodifiable List<Item<T>> items) {
        this.checkSetterPreconditions();
        this.source = CollectionSupport.copyToList(items);
    }

    @Override
    protected void doExecute(@Nonnull @NonnullElements List<Item<T>> items) throws StageProcessingException {
        for (Item<T> item : this.getSourceItems()) {
            items.add(item.copy());
        }
    }
}

