/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.metadata.dom.saml;

import jakarta.json.Json;
import jakarta.json.stream.JsonGenerator;
import jakarta.json.stream.JsonGeneratorFactory;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;
import javax.xml.namespace.QName;
import net.shibboleth.metadata.Item;
import net.shibboleth.metadata.ItemCollectionSerializer;
import net.shibboleth.metadata.dom.saml.SAMLMetadataSupport;
import net.shibboleth.metadata.dom.saml.SAMLSupport;
import net.shibboleth.metadata.dom.saml.mdattr.MDAttrSupport;
import net.shibboleth.metadata.dom.saml.mdui.MDUISupport;
import net.shibboleth.shared.annotation.constraint.NonnullElements;
import net.shibboleth.shared.component.AbstractInitializableComponent;
import net.shibboleth.shared.xml.ElementSupport;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class DiscoFeedCollectionSerializer
extends AbstractInitializableComponent
implements ItemCollectionSerializer<Element> {
    @GuardedBy(value="this")
    private boolean prettyPrinting;
    @GuardedBy(value="this")
    private boolean includingLegacyDisplayNames;
    @GuardedBy(value="this")
    private boolean includingEntityAttributes;

    public final synchronized boolean isPrettyPrinting() {
        return this.prettyPrinting;
    }

    public synchronized void setPrettyPrinting(boolean pretty) {
        this.prettyPrinting = pretty;
    }

    public final synchronized boolean isIncludingLegacyDisplayNames() {
        return this.includingLegacyDisplayNames;
    }

    public synchronized void setIncludingLegacyDisplayNames(boolean includeLegacyDisplayNames) {
        this.includingLegacyDisplayNames = includeLegacyDisplayNames;
    }

    public final synchronized boolean isIncludingEntityAttributes() {
        return this.includingEntityAttributes;
    }

    public synchronized void setIncludingEntityAttributes(boolean includeEntityAttributes) {
        this.includingEntityAttributes = includeEntityAttributes;
    }

    @Nullable
    private Element findFirstUIInfo(@Nonnull @NonnullElements List<Element> idpDescriptors) {
        for (Element idpDescriptor : idpDescriptors) {
            assert (idpDescriptor != null);
            Element uiInfo = SAMLMetadataSupport.getDescriptorExtension(idpDescriptor, MDUISupport.UIINFO_NAME);
            if (uiInfo == null) continue;
            return uiInfo;
        }
        return null;
    }

    private void writeValueLangList(@Nonnull JsonGenerator gen, @Nonnull @NonnullElements List<Element> elements, @Nonnull String key) {
        gen.writeStartArray(key);
        for (Element element : elements) {
            gen.writeStartObject();
            gen.write("value", element.getTextContent());
            gen.write("lang", element.getAttribute("xml:lang"));
            gen.writeEnd();
        }
        gen.writeEnd();
    }

    private void writeValueLangList(@Nonnull JsonGenerator gen, @Nonnull Element uiInfo, @Nonnull QName elementName, @Nonnull String key) {
        List elements = ElementSupport.getChildElements((Node)uiInfo, (QName)elementName);
        if (!elements.isEmpty()) {
            this.writeValueLangList(gen, elements, key);
        }
    }

    private void writeEntityAttributes(@Nonnull JsonGenerator gen, @Nonnull Element entity) {
        List attributes;
        Element ext = SAMLMetadataSupport.getDescriptorExtension(entity, MDAttrSupport.ENTITY_ATTRIBUTES_NAME);
        if (ext != null && !(attributes = ElementSupport.getChildElements((Node)ext, (QName)SAMLSupport.ATTRIBUTE_NAME)).isEmpty()) {
            gen.writeStartArray("EntityAttributes");
            for (Element attribute : attributes) {
                assert (attribute != null);
                List values = ElementSupport.getChildElements((Node)attribute, (QName)SAMLSupport.ATTRIBUTE_VALUE_NAME);
                if (values.isEmpty()) continue;
                gen.writeStartObject();
                gen.write("name", attribute.getAttribute("Name"));
                gen.writeStartArray("values");
                for (Element value : values) {
                    gen.write(value.getTextContent());
                }
                gen.writeEnd();
                gen.writeEnd();
            }
            gen.writeEnd();
        }
    }

    private void writeLogos(@Nonnull JsonGenerator gen, @Nonnull Element uiInfo) {
        List logos = ElementSupport.getChildElements((Node)uiInfo, (QName)MDUISupport.LOGO_NAME);
        if (!logos.isEmpty()) {
            gen.writeStartArray("Logos");
            for (Element logo : logos) {
                gen.writeStartObject();
                gen.write("value", logo.getTextContent());
                gen.write("height", logo.getAttribute("height"));
                gen.write("width", logo.getAttribute("width"));
                Attr lang = logo.getAttributeNode("xml:lang");
                if (lang != null) {
                    gen.write("lang", lang.getTextContent());
                }
                gen.writeEnd();
            }
            gen.writeEnd();
        }
    }

    private void writeDisplayNames(@Nonnull JsonGenerator gen, @Nonnull Element entity, @Nullable Element uiInfo) {
        List displayNames;
        Element org;
        List displayNames2;
        if (uiInfo != null && !(displayNames2 = ElementSupport.getChildElements((Node)uiInfo, (QName)MDUISupport.DISPLAYNAME_NAME)).isEmpty()) {
            this.writeValueLangList(gen, displayNames2, "DisplayNames");
            return;
        }
        if (this.isIncludingLegacyDisplayNames() && (org = ElementSupport.getFirstChildElement((Node)entity, (QName)SAMLMetadataSupport.ORGANIZATION_NAME)) != null && !(displayNames = ElementSupport.getChildElements((Node)org, (QName)SAMLMetadataSupport.ORGANIZATIONDISPLAYNAME_NAME)).isEmpty()) {
            this.writeValueLangList(gen, displayNames, "DisplayNames");
        }
    }

    @Override
    public void serializeCollection(@Nonnull @NonnullElements Collection<Item<Element>> items, @Nonnull OutputStream output) throws IOException {
        this.checkComponentActive();
        HashMap<String, String> generatorConfig = new HashMap<String, String>();
        if (this.isPrettyPrinting()) {
            generatorConfig.put("jakarta.json.stream.JsonGenerator.prettyPrinting", "true");
        }
        JsonGeneratorFactory factory = Json.createGeneratorFactory(generatorConfig);
        JsonGenerator gen = factory.createGenerator(output);
        gen.writeStartArray();
        for (Item<Element> item : items) {
            List idpDescriptors;
            Element entity = item.unwrap();
            if (!SAMLMetadataSupport.isEntityDescriptor(entity) || (idpDescriptors = ElementSupport.getChildElements((Node)entity, (QName)SAMLMetadataSupport.IDP_SSO_DESCRIPTOR_NAME)).isEmpty()) continue;
            gen.writeStartObject();
            gen.write("entityID", SAMLMetadataSupport.getEntityID(entity));
            Element uiInfo = this.findFirstUIInfo(idpDescriptors);
            this.writeDisplayNames(gen, entity, uiInfo);
            if (uiInfo != null) {
                this.writeValueLangList(gen, uiInfo, MDUISupport.DESCRIPTION_NAME, "Descriptions");
                this.writeValueLangList(gen, uiInfo, MDUISupport.KEYWORDS_NAME, "Keywords");
                this.writeValueLangList(gen, uiInfo, MDUISupport.INFORMATIONURL_NAME, "InformationURLs");
                this.writeValueLangList(gen, uiInfo, MDUISupport.PRIVACYSTATEMENTURL_NAME, "PrivacyStatementURLs");
                this.writeLogos(gen, uiInfo);
            }
            if (this.isIncludingEntityAttributes()) {
                this.writeEntityAttributes(gen, entity);
            }
            gen.writeEnd();
        }
        gen.writeEnd();
        gen.close();
    }
}

