/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.metadata.dom;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;
import net.shibboleth.metadata.ErrorStatus;
import net.shibboleth.metadata.Item;
import net.shibboleth.metadata.ItemMetadata;
import net.shibboleth.metadata.pipeline.AbstractIteratingStage;
import net.shibboleth.shared.collection.ClassToInstanceMultiMap;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.LoggerFactory;
import net.shibboleth.shared.xml.ElementSupport;
import org.slf4j.Logger;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

@ThreadSafe
public abstract class AbstractNamespacesStrippingStage
extends AbstractIteratingStage<Element> {
    @Nonnull
    private static final Logger LOG = LoggerFactory.getLogger(AbstractNamespacesStrippingStage.class);

    protected abstract boolean removingNamespace(@Nullable String var1);

    @Override
    protected void doExecute(@Nonnull Item<Element> item) {
        Element element = item.unwrap();
        if (this.removingNamespace(element.getNamespaceURI())) {
            ClassToInstanceMultiMap<ItemMetadata> metadata = item.getItemMetadata();
            metadata.put((Object)new ErrorStatus(this.ensureId(), "can't strip namespace from document element"));
            return;
        }
        this.processElement(element, 0);
    }

    private void processAttributes(@Nonnull Element element) {
        Constraint.isNotNull((Object)element, (String)"Element can not be null");
        NamedNodeMap attributes = element.getAttributes();
        ArrayList<Attr> removeTarget = new ArrayList<Attr>();
        ArrayList<Attr> removePrefix = new ArrayList<Attr>();
        for (int aIndex = 0; aIndex < attributes.getLength(); ++aIndex) {
            Attr attribute = (Attr)attributes.item(aIndex);
            String attrNamespace = attribute.getNamespaceURI();
            String attrLocalName = attribute.getLocalName();
            LOG.trace("checking attribute {{}}:{}", (Object)attrNamespace, (Object)attrLocalName);
            if ("http://www.w3.org/2000/xmlns/".equals(attrNamespace)) {
                if (!this.removingNamespace(attribute.getTextContent())) continue;
                LOG.trace("   prefix {} definition; will remove", (Object)attrLocalName);
                removeTarget.add(attribute);
                continue;
            }
            if (attrNamespace == null || !this.removingNamespace(attrNamespace)) continue;
            LOG.trace("   in target namespace; will remove");
            removePrefix.add(attribute);
        }
        for (Attr a : removeTarget) {
            element.removeAttributeNode(a);
        }
        for (Attr a : removePrefix) {
            element.removeAttributeNode(a);
        }
    }

    private void processElement(@Nonnull Element element, int depth) {
        Constraint.isNotNull((Object)element, (String)"Element can not be null");
        LOG.trace("{}: element {}", (Object)depth, (Object)element.getLocalName());
        if (this.removingNamespace(element.getNamespaceURI())) {
            LOG.trace("{}: removing element entirely", (Object)depth);
            element.getParentNode().removeChild(element);
            return;
        }
        List children = ElementSupport.getChildElements((Node)element);
        for (Element child : children) {
            assert (child != null);
            this.processElement(child, depth + 1);
        }
        this.processAttributes(element);
    }
}

