/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.metadata.dom;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.GuardedBy;
import javax.xml.namespace.QName;
import net.shibboleth.metadata.dom.AbstractElementVisitingValidationStage;
import net.shibboleth.metadata.dom.DOMTraversalContext;
import net.shibboleth.metadata.pipeline.StageProcessingException;
import net.shibboleth.shared.annotation.constraint.NonnullElements;
import net.shibboleth.shared.annotation.constraint.Unmodifiable;
import net.shibboleth.shared.collection.CollectionSupport;
import net.shibboleth.shared.component.ComponentInitializationException;
import net.shibboleth.shared.logic.Constraint;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;

public abstract class AbstractAttributeValidationStage<T>
extends AbstractElementVisitingValidationStage<T, Attr> {
    @Nonnull
    @NonnullElements
    @Unmodifiable
    @GuardedBy(value="this")
    private Set<QName> attributeNames = CollectionSupport.emptySet();

    @Nonnull
    public final synchronized Collection<QName> getAttributeNames() {
        return this.attributeNames;
    }

    public final synchronized void setAttributeNames(@Nonnull Collection<String> names) {
        this.checkSetterPreconditions();
        Constraint.isNotNull(names, (String)"attributeNames may not be null");
        HashSet<QName> qnames = new HashSet<QName>();
        for (String name : names) {
            qnames.add(new QName(name));
        }
        this.attributeNames = CollectionSupport.copyToSet(qnames);
    }

    public final synchronized void setAttributeName(@Nonnull String name) {
        this.checkSetterPreconditions();
        Constraint.isNotNull((Object)name, (String)"unqualifiedAttributeName may not be null");
        this.attributeNames = CollectionSupport.setOf((Object)new QName(name));
    }

    public final synchronized void setQualifiedAttributeNames(@Nonnull Collection<QName> names) {
        this.checkSetterPreconditions();
        Constraint.isNotNull(names, (String)"attributeNames may not be null");
        this.attributeNames = CollectionSupport.copyToSet(names);
    }

    public final synchronized void setQualifiedAttributeName(@Nonnull QName name) {
        this.checkSetterPreconditions();
        Constraint.isNotNull((Object)name, (String)"attributeName may not be null");
        this.attributeNames = CollectionSupport.setOf((Object)name);
    }

    @Override
    protected void visit(@Nonnull Element element, @Nonnull DOMTraversalContext context) throws StageProcessingException {
        NamedNodeMap attributes = element.getAttributes();
        assert (attributes != null);
        for (int i = 0; i < attributes.getLength(); ++i) {
            Attr attr = (Attr)attributes.item(i);
            if (attr == null || !this.applicable(attr, context)) continue;
            this.applyValidators(this.convert(attr), context);
        }
    }

    protected boolean applicable(@Nonnull Attr attr, @Nonnull DOMTraversalContext context) {
        QName attrName = new QName(attr.getNamespaceURI(), attr.getLocalName());
        return this.getAttributeNames().contains(attrName);
    }

    @Override
    protected synchronized void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        if (this.attributeNames.isEmpty()) {
            throw new ComponentInitializationException("attributeNames may not be empty");
        }
    }
}

