/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.metadata.cli;

import java.io.File;
import java.util.ArrayList;
import java.util.Date;
import javax.annotation.Nonnull;
import net.shibboleth.metadata.Version;
import net.shibboleth.metadata.cli.SimpleCommandLineArguments;
import net.shibboleth.metadata.pipeline.Pipeline;
import net.shibboleth.metadata.pipeline.TerminationException;
import net.shibboleth.shared.primitive.LoggerFactory;
import org.slf4j.Logger;
import org.springframework.beans.BeansException;
import org.springframework.context.support.FileSystemXmlApplicationContext;

public final class SimpleCommandLine {
    public static final int RC_INIT = 1;
    private static Logger log;

    private SimpleCommandLine() {
    }

    public static void main(String[] args) {
        SimpleCommandLineArguments cli = new SimpleCommandLineArguments();
        cli.parseCommandLineArguments(args);
        if (cli.doHelp()) {
            cli.printHelp(System.out);
            return;
        }
        if (cli.doVersion()) {
            System.out.println(Version.getVersion());
            return;
        }
        SimpleCommandLine.initLogging(cli);
        try {
            SimpleCommandLine.process(cli);
        }
        catch (ErrorException e) {
            log.error(e.getMessage(), e.getCause());
            System.exit(e.error);
        }
    }

    private static void process(@Nonnull SimpleCommandLineArguments cli) throws ErrorException {
        String fileUri = new File(cli.getInputFile()).toURI().toString();
        assert (fileUri != null);
        log.debug("Initializing Spring context with configuration file {}", (Object)fileUri);
        try (FileSystemXmlApplicationContext appCtx = new FileSystemXmlApplicationContext(fileUri);){
            log.debug("Retrieving pipeline from Spring context");
            String pipelineName = cli.getPipelineName();
            assert (pipelineName != null);
            Pipeline pipeline = (Pipeline)appCtx.getBean(pipelineName, Pipeline.class);
            try {
                if (!pipeline.isInitialized()) {
                    log.debug("Retrieved pipeline has not been initialized, initializing it now");
                    pipeline.initialize();
                } else {
                    log.debug("Retrieved pipeline has already been initialized");
                }
                Date startTime = new Date();
                log.info("Pipeline '{}' execution starting at {}", (Object)pipelineName, (Object)startTime);
                pipeline.execute(new ArrayList());
                Date endTime = new Date();
                log.info("Pipeline '{}' execution completed at {}; run time {} seconds", new Object[]{pipelineName, endTime, Float.valueOf((float)(endTime.getTime() - startTime.getTime()) / 1000.0f)});
            }
            catch (TerminationException e) {
                if (cli.doVerboseOutput()) {
                    throw new ErrorException(1, "TerminationException during processing", e);
                }
                throw new ErrorException(1, "Terminated: " + e.getMessage());
            }
            catch (Exception e) {
                throw new ErrorException(1, "Error processing information", e);
            }
        }
        catch (BeansException e) {
            throw new ErrorException(1, "Unable to initialize Spring context", e);
        }
    }

    private static void setLoggingProperty(@Nonnull String value) {
        System.setProperty("logback.configurationFile", value);
    }

    private static void setLoggingToLocalResource(@Nonnull String value) {
        SimpleCommandLine.setLoggingProperty("net/shibboleth/metadata/cli/" + value);
    }

    protected static void initLogging(SimpleCommandLineArguments cli) {
        String config = cli.getLoggingConfiguration();
        if (config != null) {
            SimpleCommandLine.setLoggingProperty(config);
        } else if (cli.doVerboseOutput()) {
            SimpleCommandLine.setLoggingToLocalResource("logger-verbose.xml");
        } else if (cli.doQuietOutput()) {
            SimpleCommandLine.setLoggingToLocalResource("logger-quiet.xml");
        } else {
            SimpleCommandLine.setLoggingToLocalResource("logger-normal.xml");
        }
        log = LoggerFactory.getLogger(SimpleCommandLine.class);
    }

    private static class ErrorException
    extends Exception {
        private static final long serialVersionUID = 1L;
        private final int error;

        ErrorException(int errorCode, @Nonnull String message, Throwable cause) {
            super(message, cause);
            this.error = errorCode;
        }

        ErrorException(int errorCode, @Nonnull String message) {
            super(message);
            this.error = errorCode;
        }
    }
}

