/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.shared.spring.factory;

import javax.annotation.Nullable;
import net.shibboleth.shared.component.DestructableComponent;
import net.shibboleth.shared.component.InitializableComponent;
import net.shibboleth.shared.primitive.LoggerFactory;
import net.shibboleth.shared.spring.factory.AbstractFactoryBean;
import org.springframework.beans.factory.BeanCreationException;

public abstract class AbstractComponentAwareFactoryBean<T>
extends AbstractFactoryBean<T> {
    private boolean throwIfNull = true;

    @Override
    protected void destroyInstance(@Nullable T instance) throws Exception {
        super.destroyInstance(instance);
        if (instance instanceof DestructableComponent) {
            DestructableComponent dc = (DestructableComponent)instance;
            dc.destroy();
        }
    }

    public void setThrowIfNull(boolean flag) {
        this.throwIfNull = flag;
    }

    @Override
    @Nullable
    protected final T createInstance() throws Exception {
        if (!this.isSingleton()) {
            LoggerFactory.getLogger(AbstractComponentAwareFactoryBean.class).error("Configuration error: {} should not be used to create prototype beans.  Destroy is never called for prototype beans", AbstractComponentAwareFactoryBean.class);
            throw new BeanCreationException("Do not use AbstractComponentAwareFactoryBean to create prototype beans");
        }
        T theBean = this.doCreateInstance();
        if (this.throwIfNull && theBean == null) {
            throw new BeanCreationException("Bean was null and throwIfNull was set");
        }
        if (theBean instanceof InitializableComponent) {
            InitializableComponent ic = (InitializableComponent)theBean;
            ic.initialize();
        }
        return theBean;
    }

    @Nullable
    protected abstract T doCreateInstance() throws Exception;
}

