/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.shared.spring.servlet.impl;

import jakarta.servlet.FilterChain;
import jakarta.servlet.FilterConfig;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletOutputStream;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.Cookie;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpServletResponseWrapper;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import net.shibboleth.shared.annotation.constraint.Live;
import net.shibboleth.shared.servlet.AbstractConditionalFilter;
import net.shibboleth.shared.spring.servlet.ChainableFilter;

public class CookieBufferingFilter
extends AbstractConditionalFilter
implements ChainableFilter {
    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void destroy() {
    }

    @Override
    public int getOrder() {
        return ChainableFilter.FilterOrder.NEUTRAL.getValue();
    }

    protected void runFilter(@Nonnull ServletRequest request, @Nonnull ServletResponse response, @Nonnull FilterChain chain) throws IOException, ServletException {
        if (!(request instanceof HttpServletRequest)) {
            throw new ServletException("Request is not an instance of HttpServletRequest");
        }
        if (!(response instanceof HttpServletResponse)) {
            throw new ServletException("Response is not an instance of HttpServletResponse");
        }
        chain.doFilter(request, (ServletResponse)new CookieBufferingHttpServletResponseProxy((HttpServletResponse)response));
    }

    private class CookieBufferingHttpServletResponseProxy
    extends HttpServletResponseWrapper {
        @Nonnull
        private Map<String, Cookie> cookieMap;

        public CookieBufferingHttpServletResponseProxy(HttpServletResponse response) {
            super(response);
            this.cookieMap = new HashMap<String, Cookie>();
        }

        public void addCookie(Cookie cookie) {
            this.cookieMap.put(cookie.getName(), cookie);
        }

        @Nonnull
        @Live
        protected Map<String, Cookie> getCookies() {
            return this.cookieMap;
        }

        public ServletOutputStream getOutputStream() throws IOException {
            this.dumpCookies();
            return super.getOutputStream();
        }

        public PrintWriter getWriter() throws IOException {
            this.dumpCookies();
            return super.getWriter();
        }

        public void sendError(int sc, String msg) throws IOException {
            this.dumpCookies();
            super.sendError(sc, msg);
        }

        public void sendError(int sc) throws IOException {
            this.dumpCookies();
            super.sendError(sc);
        }

        public void sendRedirect(String location) throws IOException {
            this.dumpCookies();
            super.sendRedirect(location);
        }

        protected void dumpCookies() {
            for (Cookie cookie : this.cookieMap.values()) {
                ((HttpServletResponse)this.getResponse()).addCookie(cookie);
            }
            this.cookieMap.clear();
        }
    }
}

