/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.metadata.validate;

import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;
import net.shibboleth.metadata.Item;
import net.shibboleth.metadata.pipeline.StageProcessingException;
import net.shibboleth.metadata.validate.BaseValidator;
import net.shibboleth.metadata.validate.Validator;
import net.shibboleth.metadata.validate.ValidatorSequence;
import net.shibboleth.shared.component.ComponentInitializationException;

@ThreadSafe
public abstract class BaseAsValidator<V, A>
extends BaseValidator
implements Validator<V> {
    @Nonnull
    @GuardedBy(value="this")
    private ValidatorSequence<A> validators = new ValidatorSequence();
    private boolean conversionRequired = true;

    public synchronized void setValidators(@Nonnull List<Validator<A>> newValidators) {
        this.validators.setValidators(newValidators);
    }

    @Nonnull
    public synchronized List<Validator<A>> getValidators() {
        return this.validators.getValidators();
    }

    public void setConversionRequired(boolean required) {
        this.conversionRequired = required;
    }

    public boolean isConversionRequired() {
        return this.conversionRequired;
    }

    @Nonnull
    protected abstract A convert(@Nonnull V var1) throws IllegalArgumentException;

    @Override
    @Nonnull
    public Validator.Action validate(@Nonnull V t, @Nonnull Item<?> item, @Nonnull String callerId, @Nullable String valueContext) throws StageProcessingException {
        try {
            A v = this.convert(t);
            String context = valueContext == null ? t.toString() : valueContext;
            return this.validators.validate(v, item, this.makeComponentId(callerId), context);
        }
        catch (IllegalArgumentException e) {
            if (this.isConversionRequired()) {
                this.addErrorMessage(t, item, callerId, e);
                return Validator.Action.DONE;
            }
            return Validator.Action.CONTINUE;
        }
    }

    protected void doDestroy() {
        this.validators.destroy();
        super.doDestroy();
    }

    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        this.validators.setId(this.ensureId());
        this.validators.initialize();
    }
}

