/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.metadata.pipeline;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;
import net.shibboleth.metadata.Item;
import net.shibboleth.metadata.SimpleItemCollectionFactory;
import net.shibboleth.metadata.pipeline.AbstractStage;
import net.shibboleth.metadata.pipeline.Pipeline;
import net.shibboleth.metadata.pipeline.PipelineAndStrategy;
import net.shibboleth.metadata.pipeline.StageProcessingException;
import net.shibboleth.metadata.pipeline.impl.DirectExecutor;
import net.shibboleth.metadata.pipeline.impl.FutureSupport;
import net.shibboleth.metadata.pipeline.impl.PipelineCallable;
import net.shibboleth.shared.annotation.constraint.NonnullElements;
import net.shibboleth.shared.annotation.constraint.Unmodifiable;
import net.shibboleth.shared.collection.CollectionSupport;
import net.shibboleth.shared.component.ComponentInitializationException;
import net.shibboleth.shared.logic.Constraint;

@ThreadSafe
public class PipelineDemultiplexerStage<T>
extends AbstractStage<T> {
    @Nonnull
    @GuardedBy(value="this")
    private Executor executor = new DirectExecutor();
    @GuardedBy(value="this")
    private boolean waitingForPipelines = true;
    @Nonnull
    @GuardedBy(value="this")
    private Supplier<List<Item<T>>> collectionFactory = new SimpleItemCollectionFactory();
    @Nonnull
    @NonnullElements
    @Unmodifiable
    @GuardedBy(value="this")
    private List<PipelineAndStrategy<T>> pipelinesAndStrategies = CollectionSupport.emptyList();

    @Nonnull
    public final synchronized Executor getExecutor() {
        return this.executor;
    }

    public synchronized void setExecutor(@Nonnull Executor exec) {
        this.checkSetterPreconditions();
        this.executor = (Executor)Constraint.isNotNull((Object)exec, (String)"executor can not be null");
    }

    public final synchronized boolean isWaitingForPipelines() {
        return this.waitingForPipelines;
    }

    public synchronized void setWaitingForPipelines(boolean isWaiting) {
        this.checkSetterPreconditions();
        this.waitingForPipelines = isWaiting;
    }

    @Nonnull
    public final synchronized Supplier<List<Item<T>>> getCollectionFactory() {
        return this.collectionFactory;
    }

    public synchronized void setCollectionFactory(@Nonnull Supplier<List<Item<T>>> factory) {
        this.checkSetterPreconditions();
        this.collectionFactory = (Supplier)Constraint.isNotNull(factory, (String)"Collection factory can not be null");
    }

    @Nonnull
    @NonnullElements
    @Unmodifiable
    public final synchronized List<PipelineAndStrategy<T>> getPipelinesAndStrategies() {
        return this.pipelinesAndStrategies;
    }

    public synchronized void setPipelinesAndStrategies(@Nonnull @NonnullElements @Unmodifiable List<PipelineAndStrategy<T>> passes) {
        this.checkSetterPreconditions();
        for (PipelineAndStrategy<T> pass : passes) {
            Constraint.isNotNull(pass.pipeline(), (String)"Pipeline can not be null");
            Constraint.isNotNull(pass.strategy(), (String)"Predicate can not be null");
        }
        this.pipelinesAndStrategies = CollectionSupport.copyToList(passes);
    }

    @Override
    protected void doExecute(@Nonnull @NonnullElements List<Item<T>> items) throws StageProcessingException {
        ArrayList<FutureTask<T>> pipelineFutures = new ArrayList<FutureTask<T>>();
        for (PipelineAndStrategy<T> pipelineAndStrategy : this.getPipelinesAndStrategies()) {
            List<Item<T>> selectedItems = this.getCollectionFactory().get();
            assert (selectedItems != null);
            for (Item<T> item : items) {
                if (!pipelineAndStrategy.strategy().test(item)) continue;
                selectedItems.add(item.copy());
            }
            Pipeline<T> pipeline = pipelineAndStrategy.pipeline();
            assert (pipeline != null);
            PipelineCallable<T> callable = new PipelineCallable<T>(pipeline, selectedItems);
            FutureTask<T> future = new FutureTask<T>(callable);
            this.getExecutor().execute(future);
            pipelineFutures.add(future);
        }
        if (this.isWaitingForPipelines()) {
            for (Future future : pipelineFutures) {
                assert (future != null);
                FutureSupport.futureItems(future);
            }
        }
    }

    protected synchronized void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        if (this.pipelinesAndStrategies.isEmpty()) {
            throw new ComponentInitializationException("Pipeline and selection strategy collection can not be empty");
        }
        for (PipelineAndStrategy<T> pipelineAndStrategy : this.pipelinesAndStrategies) {
            Pipeline<T> pipeline = pipelineAndStrategy.pipeline();
            assert (pipeline != null);
            if (pipeline.isInitialized()) continue;
            pipeline.initialize();
        }
    }
}

