/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.metadata.pipeline;

import java.util.Collection;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;
import net.shibboleth.metadata.Item;
import net.shibboleth.metadata.ItemMetadata;
import net.shibboleth.metadata.pipeline.AbstractIteratingStage;
import net.shibboleth.metadata.pipeline.StageProcessingException;
import net.shibboleth.shared.annotation.constraint.NonnullElements;
import net.shibboleth.shared.annotation.constraint.Unmodifiable;
import net.shibboleth.shared.collection.CollectionSupport;
import net.shibboleth.shared.logic.Constraint;

@ThreadSafe
public class ItemMetadataAddingStage<T>
extends AbstractIteratingStage<T> {
    @Nonnull
    @NonnullElements
    @Unmodifiable
    @GuardedBy(value="this")
    private List<ItemMetadata> additionalItemMetadata = CollectionSupport.emptyList();

    @Nonnull
    @NonnullElements
    @Unmodifiable
    public final synchronized Collection<ItemMetadata> getAdditionalItemMetadata() {
        return this.additionalItemMetadata;
    }

    public synchronized void setAdditionalItemMetadata(@Nonnull @NonnullElements @Unmodifiable Collection<ItemMetadata> metadata) {
        this.checkSetterPreconditions();
        Constraint.isNotNull(metadata, (String)"additional metadata collection must not be null");
        this.additionalItemMetadata = CollectionSupport.copyToList(metadata);
    }

    @Override
    protected void doExecute(@Nonnull Item<T> item) throws StageProcessingException {
        item.getItemMetadata().putAll(this.getAdditionalItemMetadata());
    }
}

