/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.metadata.dom.saml;

import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;
import javax.xml.namespace.QName;
import net.shibboleth.metadata.Item;
import net.shibboleth.metadata.dom.saml.SAMLMetadataSupport;
import net.shibboleth.metadata.pipeline.AbstractFilteringStage;
import net.shibboleth.shared.annotation.constraint.NonnullElements;
import net.shibboleth.shared.annotation.constraint.Unmodifiable;
import net.shibboleth.shared.collection.CollectionSupport;
import net.shibboleth.shared.primitive.LoggerFactory;
import net.shibboleth.shared.xml.DOMTypeSupport;
import net.shibboleth.shared.xml.ElementSupport;
import net.shibboleth.shared.xml.QNameSupport;
import org.slf4j.Logger;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

@ThreadSafe
public class EntityRoleFilterStage
extends AbstractFilteringStage<Element> {
    @Nonnull
    @NonnullElements
    @Unmodifiable
    private static final Set<QName> NAMED_ROLES = CollectionSupport.setOf((Object[])new QName[]{SAMLMetadataSupport.IDP_SSO_DESCRIPTOR_NAME, SAMLMetadataSupport.SP_SSO_DESCRIPTOR_NAME, SAMLMetadataSupport.AUTHN_AUTHORITY_DESCRIPTOR_NAME, SAMLMetadataSupport.ATTRIBUTE_AUTHORITY_DESCRIPTOR_NAME, SAMLMetadataSupport.PDP_DESCRIPTOR_NAME});
    @Nonnull
    private static final Logger LOG = LoggerFactory.getLogger(EntityRoleFilterStage.class);
    @Nonnull
    @NonnullElements
    @Unmodifiable
    @GuardedBy(value="this")
    private Set<QName> designatedRoles = CollectionSupport.emptySet();
    @GuardedBy(value="this")
    private boolean keepingRoles;
    @GuardedBy(value="this")
    private boolean removingRolelessEntities = true;
    @GuardedBy(value="this")
    private boolean removingEntitylessEntitiesDescriptor = true;

    @Nonnull
    @NonnullElements
    @Unmodifiable
    public final synchronized Collection<QName> getDesignatedRoles() {
        return this.designatedRoles;
    }

    public synchronized void setDesignatedRoles(@Nonnull @NonnullElements @Unmodifiable Collection<QName> roles) {
        this.checkSetterPreconditions();
        this.designatedRoles = CollectionSupport.copyToSet(roles);
    }

    public final synchronized boolean isKeepingRoles() {
        return this.keepingRoles;
    }

    public synchronized void setKeepingRoles(boolean keeping) {
        this.checkSetterPreconditions();
        this.keepingRoles = keeping;
    }

    public final synchronized boolean isRemovingRolelessEntities() {
        return this.removingRolelessEntities;
    }

    public synchronized void setRemoveRolelessEntities(boolean remove) {
        this.checkSetterPreconditions();
        this.removingRolelessEntities = remove;
    }

    public final synchronized boolean isRemovingEntitylessEntitiesDescriptor() {
        return this.removingEntitylessEntitiesDescriptor;
    }

    public synchronized void setRemovingEntitylessEntitiesDescriptor(boolean remove) {
        this.checkSetterPreconditions();
        this.removingEntitylessEntitiesDescriptor = remove;
    }

    @Override
    protected boolean doExecute(@Nonnull Item<Element> item) {
        Element descriptor = item.unwrap();
        return !(SAMLMetadataSupport.isEntitiesDescriptor(descriptor) ? this.processEntitiesDescriptor(descriptor) : SAMLMetadataSupport.isEntityDescriptor(descriptor) && this.processEntityDescriptor(descriptor));
    }

    protected boolean processEntitiesDescriptor(@Nonnull Element entitiesDescriptor) {
        boolean remove = true;
        List childEntitiesDescriptors = ElementSupport.getChildElements((Node)entitiesDescriptor, (QName)SAMLMetadataSupport.ENTITIES_DESCRIPTOR_NAME);
        for (Element descriptor : childEntitiesDescriptors) {
            assert (descriptor != null);
            if (this.processEntitiesDescriptor(descriptor)) {
                entitiesDescriptor.removeChild(descriptor);
                continue;
            }
            remove = false;
        }
        List childEntityDescriptors = ElementSupport.getChildElements((Node)entitiesDescriptor, (QName)SAMLMetadataSupport.ENTITY_DESCRIPTOR_NAME);
        for (Element descriptor : childEntityDescriptors) {
            assert (descriptor != null);
            if (this.processEntityDescriptor(descriptor)) {
                entitiesDescriptor.removeChild(descriptor);
                continue;
            }
            remove = false;
        }
        return remove && this.isRemovingEntitylessEntitiesDescriptor();
    }

    protected boolean processEntityDescriptor(@Nonnull Element entityDescriptor) {
        if (this.getDesignatedRoles().isEmpty()) {
            return false;
        }
        String entityId = SAMLMetadataSupport.getEntityID(entityDescriptor);
        assert (entityId != null);
        LOG.debug("{} pipeline stage filtering roles from EntityDescriptor {}", (Object)this.getId(), (Object)entityId);
        boolean hasRoles = this.hasFilteredRoles(entityId, entityDescriptor);
        return !hasRoles && this.isRemovingRolelessEntities();
    }

    private boolean hasFilteredRoles(@Nonnull String entityId, @Nonnull Element entityDescriptor) {
        boolean remains = false;
        List childElements = ElementSupport.getChildElements((Node)entityDescriptor);
        for (Element child : childElements) {
            QName roleIdentifier;
            assert (child != null);
            QName childQName = QNameSupport.getNodeQName((Node)child);
            if (Objects.equals(childQName, SAMLMetadataSupport.ROLE_DESCRIPTOR_NAME)) {
                roleIdentifier = DOMTypeSupport.getXSIType((Element)child);
            } else {
                if (!NAMED_ROLES.contains(childQName)) continue;
                roleIdentifier = childQName;
            }
            if (roleIdentifier == null) continue;
            boolean isDesignatedRole = this.getDesignatedRoles().contains(roleIdentifier);
            if (this.isKeepingRoles() && !isDesignatedRole || !this.isKeepingRoles() && isDesignatedRole) {
                LOG.debug("{} pipeline stage removing role {} from EntityDescriptor {}", new Object[]{this.getId(), roleIdentifier, entityId});
                entityDescriptor.removeChild(child);
                continue;
            }
            LOG.debug("{} pipeline did not remove role {} from EntityDescriptor {}", new Object[]{this.getId(), roleIdentifier, entityId});
            remains = true;
        }
        return remains;
    }
}

