/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.metadata.dom.saml;

import javax.annotation.Nonnull;
import javax.annotation.concurrent.Immutable;
import net.shibboleth.metadata.dom.SimpleElementMatcher;
import net.shibboleth.metadata.dom.saml.SAMLSupport;
import net.shibboleth.shared.logic.Constraint;
import org.w3c.dom.Element;

@Immutable
public class AttributeElementMatcher
extends SimpleElementMatcher {
    @Nonnull
    private final String matchFormat;
    @Nonnull
    private final String matchName;

    public AttributeElementMatcher(@Nonnull String name, @Nonnull String format) {
        super(SAMLSupport.ATTRIBUTE_NAME);
        this.matchName = (String)Constraint.isNotNull((Object)name, (String)"attribute name must not be null");
        this.matchFormat = (String)Constraint.isNotNull((Object)format, (String)"attribute name format must not be null");
    }

    @Override
    public boolean match(@Nonnull Element element) {
        if (!super.match(element)) {
            return false;
        }
        return this.matchFormat.equals(SAMLSupport.extractAttributeNameFormat(element)) && this.matchName.equals(element.getAttribute("Name"));
    }
}

