/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.metadata.dom;

import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;
import net.shibboleth.metadata.Item;
import net.shibboleth.metadata.dom.DOMElementItem;
import net.shibboleth.metadata.pipeline.AbstractStage;
import net.shibboleth.metadata.pipeline.StageProcessingException;
import net.shibboleth.shared.annotation.constraint.Live;
import net.shibboleth.shared.annotation.constraint.NonnullAfterInit;
import net.shibboleth.shared.annotation.constraint.NonnullElements;
import net.shibboleth.shared.component.ComponentInitializationException;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.LoggerFactory;
import net.shibboleth.shared.xml.ParserPool;
import org.slf4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

@ThreadSafe
public class DOMFilesystemSourceStage
extends AbstractStage<Element> {
    @Nonnull
    private static final Logger LOG = LoggerFactory.getLogger(DOMFilesystemSourceStage.class);
    @NonnullAfterInit
    @GuardedBy(value="this")
    private ParserPool parserPool;
    @NonnullAfterInit
    @GuardedBy(value="this")
    private File sourceFile;
    @Nullable
    @GuardedBy(value="this")
    private FileFilter sourceFileFilter;
    @GuardedBy(value="this")
    private boolean recurseDirectories;
    @GuardedBy(value="this")
    private boolean noSourceFilesAnError;
    @GuardedBy(value="this")
    private boolean errorCausesSourceFailure = true;

    @NonnullAfterInit
    public final synchronized ParserPool getParserPool() {
        return this.parserPool;
    }

    public synchronized void setParserPool(@Nonnull ParserPool pool) {
        this.checkSetterPreconditions();
        this.parserPool = (ParserPool)Constraint.isNotNull((Object)pool, (String)"Parser pool can not be null");
    }

    @NonnullAfterInit
    public final synchronized File getSource() {
        return this.sourceFile;
    }

    public synchronized void setSource(@Nonnull File source) {
        this.checkSetterPreconditions();
        this.sourceFile = (File)Constraint.isNotNull((Object)source, (String)"XML source file can not be null");
    }

    @Nullable
    public final synchronized FileFilter getSourceFileFilter() {
        return this.sourceFileFilter;
    }

    public synchronized void setSourceFileFilter(@Nonnull FileFilter filter) {
        this.checkSetterPreconditions();
        this.sourceFileFilter = (FileFilter)Constraint.isNotNull((Object)filter, (String)"File filter can not be null");
    }

    public final synchronized boolean getRecurseDirectories() {
        return this.recurseDirectories;
    }

    public synchronized void setRecurseDirectories(boolean recurse) {
        this.checkSetterPreconditions();
        this.recurseDirectories = recurse;
    }

    public final synchronized boolean isNoSourceFilesAnError() {
        return this.noSourceFilesAnError;
    }

    public synchronized void setNoSourceFilesAnError(boolean isError) {
        this.checkSetterPreconditions();
        this.noSourceFilesAnError = isError;
    }

    public final synchronized boolean getErrorCausesSourceFailure() {
        return this.errorCausesSourceFailure;
    }

    public synchronized void setErrorCausesSourceFailure(boolean causesFailure) {
        this.checkSetterPreconditions();
        this.errorCausesSourceFailure = causesFailure;
    }

    @Override
    protected void doExecute(@Nonnull @NonnullElements List<Item<Element>> items) throws StageProcessingException {
        ArrayList<File> sourceFiles = new ArrayList<File>();
        File sFile = this.getSource();
        if (sFile.isFile()) {
            sourceFiles.add(sFile);
        } else {
            this.getSourceFiles(sFile, sourceFiles);
        }
        if (sourceFiles.isEmpty()) {
            if (!this.isNoSourceFilesAnError()) {
                LOG.warn("stage {}: no input XML files in source path {}", (Object)this.getId(), (Object)sFile.getPath());
                return;
            }
            throw new StageProcessingException("stage " + this.getId() + ": no source file was available for parsing");
        }
        for (File source : sourceFiles) {
            assert (source != null);
            DOMElementItem dme = this.processSourceFile(source);
            if (dme == null) continue;
            items.add(dme);
        }
    }

    protected void getSourceFiles(@Nonnull File input, @Nonnull @NonnullElements @Live List<File> collector) {
        if (input.isFile()) {
            FileFilter filter = this.getSourceFileFilter();
            if (filter == null || filter.accept(input)) {
                collector.add(input);
            }
            return;
        }
        File[] files = input.listFiles();
        if (files != null) {
            boolean recursing = this.getRecurseDirectories();
            for (File file : files) {
                if (!file.isFile() && (!recursing || !file.isDirectory())) continue;
                this.getSourceFiles(file, collector);
            }
        }
    }

    @Nullable
    protected DOMElementItem processSourceFile(@Nonnull File source) throws StageProcessingException {
        DOMElementItem dOMElementItem;
        LOG.debug("{} pipeline source parsing XML file {}", (Object)this.getId(), (Object)source.getPath());
        FileInputStream xmlIn = new FileInputStream(source);
        try {
            Document doc = this.getParserPool().parse((InputStream)xmlIn);
            dOMElementItem = new DOMElementItem(doc);
        }
        catch (Throwable throwable) {
            try {
                try {
                    xmlIn.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                if (this.getErrorCausesSourceFailure()) {
                    throw new StageProcessingException(this.getId() + " pipeline source unable to parse XML input file " + source.getPath(), e);
                }
                LOG.warn("{} pipeline source: unable to parse XML source file {}, ignoring it bad file", new Object[]{this.getId(), source.getPath(), e});
                return null;
            }
        }
        xmlIn.close();
        return dOMElementItem;
    }

    protected synchronized void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        if (this.parserPool == null) {
            throw new ComponentInitializationException("Unable to initialize " + this.getId() + ", ParserPool may not be null");
        }
        if (this.sourceFile == null) {
            throw new ComponentInitializationException("Unable to initialize " + this.getId() + ", Source may not be null");
        }
        if (!(!this.noSourceFilesAnError || this.sourceFile.exists() && this.sourceFile.canRead())) {
            throw new ComponentInitializationException("Unable to initialize " + this.getId() + ", source file/directory " + this.sourceFile.getPath() + " can not be read");
        }
    }
}

