/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.metadata;

import javax.annotation.Nonnull;

public final class Version {
    @Nonnull
    private static final String VERSION;
    private static final int MAJOR_VERSION;
    private static final int MINOR_VERSION;
    private static final int PATCH_VERSION;

    private Version() {
    }

    public static void main(String[] args) {
        Package pkg = Version.class.getPackage();
        System.out.println(pkg.getImplementationTitle() + " version " + VERSION);
    }

    @Nonnull
    public static String getVersion() {
        return VERSION;
    }

    public static int getMajorVersion() {
        return MAJOR_VERSION;
    }

    public static int getMinorVersion() {
        return MINOR_VERSION;
    }

    public static int getPatchVersion() {
        return PATCH_VERSION;
    }

    static {
        String version = Version.class.getPackage().getImplementationVersion();
        if (version != null) {
            VERSION = version;
            String[] versionParts = VERSION.split("[\\.\\+\\-]");
            MAJOR_VERSION = Integer.parseInt(versionParts[0]);
            MINOR_VERSION = Integer.parseInt(versionParts[1]);
            PATCH_VERSION = Integer.parseInt(versionParts[2]);
        } else {
            VERSION = "unknown";
            MAJOR_VERSION = 0;
            MINOR_VERSION = 0;
            PATCH_VERSION = 0;
        }
    }
}

