/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.metadata.validate.x509;

import java.security.PublicKey;
import java.security.cert.X509Certificate;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;
import net.shibboleth.metadata.Item;
import net.shibboleth.metadata.validate.BaseValidator;
import net.shibboleth.metadata.validate.Validator;

@ThreadSafe
public class X509DSADetector
extends BaseValidator
implements Validator<X509Certificate> {
    @Nonnull
    @GuardedBy(value="this")
    private Validator.Action action = Validator.Action.DONE;
    @GuardedBy(value="this")
    private boolean error = true;

    @Nonnull
    public final synchronized Validator.Action getAction() {
        return this.action;
    }

    public synchronized void setAction(@Nonnull Validator.Action newAction) {
        this.checkSetterPreconditions();
        this.action = newAction;
    }

    public synchronized void setError(boolean newValue) {
        this.checkSetterPreconditions();
        this.error = newValue;
    }

    public final synchronized boolean isError() {
        return this.error;
    }

    @Override
    @Nonnull
    public Validator.Action validate(@Nonnull X509Certificate cert, @Nonnull Item<?> item, @Nonnull String callerId) {
        PublicKey key = cert.getPublicKey();
        if ("DSA".equals(key.getAlgorithm())) {
            this.addStatus(this.isError(), "certificate contains a DSA key", item, callerId);
            return this.getAction();
        }
        return Validator.Action.CONTINUE;
    }
}

