/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.metadata.pipeline;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;
import net.shibboleth.metadata.Item;
import net.shibboleth.metadata.ItemCollectionSerializer;
import net.shibboleth.metadata.pipeline.AbstractStage;
import net.shibboleth.metadata.pipeline.StageProcessingException;
import net.shibboleth.shared.annotation.constraint.NonnullAfterInit;
import net.shibboleth.shared.annotation.constraint.NonnullElements;
import net.shibboleth.shared.component.ComponentInitializationException;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.LoggerFactory;
import org.slf4j.Logger;

@ThreadSafe
public class SerializationStage<T>
extends AbstractStage<T> {
    @Nonnull
    private static final Logger LOG = LoggerFactory.getLogger(SerializationStage.class);
    @NonnullAfterInit
    @GuardedBy(value="this")
    private File outputFile;
    @GuardedBy(value="this")
    private boolean overwritingExistingOutputFile = true;
    @NonnullAfterInit
    @GuardedBy(value="this")
    private ItemCollectionSerializer<T> serializer;

    @NonnullAfterInit
    public final synchronized File getOutputFile() {
        return this.outputFile;
    }

    public synchronized void setOutputFile(@Nonnull File file) {
        this.checkSetterPreconditions();
        this.outputFile = (File)Constraint.isNotNull((Object)file, (String)"Output file can not be null");
    }

    public final synchronized boolean isOverwritingExistingOutputFile() {
        return this.overwritingExistingOutputFile;
    }

    public synchronized void setOverwritingExistingOutputFile(boolean isOverwriting) {
        this.checkSetterPreconditions();
        this.overwritingExistingOutputFile = isOverwriting;
    }

    @NonnullAfterInit
    public final synchronized ItemCollectionSerializer<T> getSerializer() {
        return this.serializer;
    }

    public synchronized void setSerializer(@Nonnull ItemCollectionSerializer<T> itemSerializer) {
        this.checkSetterPreconditions();
        this.serializer = (ItemCollectionSerializer)Constraint.isNotNull(itemSerializer, (String)"Item collection serializer can not be null");
    }

    @Override
    protected void doExecute(@Nonnull @NonnullElements List<Item<T>> items) throws StageProcessingException {
        try (FileOutputStream stream = new FileOutputStream(this.getOutputFile());){
            this.getSerializer().serializeCollection(items, stream);
        }
        catch (IOException e) {
            throw new StageProcessingException("Error writing to output file " + this.getOutputFile().getAbsolutePath(), e);
        }
    }

    protected synchronized void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        if (this.outputFile == null) {
            throw new ComponentInitializationException("Output file can not be null");
        }
        if (this.outputFile.exists()) {
            if (!this.overwritingExistingOutputFile) {
                throw new ComponentInitializationException("Output file '" + this.outputFile.getAbsolutePath() + "' exists and stage is configured not to overwrite the file");
            }
            if (!this.outputFile.canWrite()) {
                throw new ComponentInitializationException("Can not write to output file '" + this.outputFile.getAbsolutePath() + "'");
            }
        } else {
            File parentDirectory = this.outputFile.getParentFile();
            if (parentDirectory != null) {
                if (!parentDirectory.canWrite()) {
                    throw new ComponentInitializationException("Can not write to parent directory of output file '" + this.outputFile.getAbsolutePath() + "'");
                }
            } else {
                LOG.warn("Unable to determine parent directory for output file {}, this may result in a problem during stage execution", (Object)this.outputFile.getAbsolutePath());
            }
        }
        if (this.serializer == null) {
            throw new ComponentInitializationException("Item collection serializer can not be null");
        }
    }
}

