/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.metadata.pipeline;

import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;
import net.shibboleth.metadata.Item;
import net.shibboleth.metadata.pipeline.AbstractStage;
import net.shibboleth.metadata.pipeline.ItemOrderingStrategy;
import net.shibboleth.metadata.pipeline.StageProcessingException;
import net.shibboleth.metadata.pipeline.impl.NoOpItemOrderingStrategy;
import net.shibboleth.shared.annotation.constraint.NonnullElements;
import net.shibboleth.shared.logic.Constraint;

@ThreadSafe
public class ItemOrderingStage<T>
extends AbstractStage<T> {
    @Nonnull
    @GuardedBy(value="this")
    private ItemOrderingStrategy<T> orderingStrategy = new NoOpItemOrderingStrategy();

    @Nonnull
    public final synchronized ItemOrderingStrategy<T> getItemOrderingStrategy() {
        return this.orderingStrategy;
    }

    public synchronized void setItemOrderingStrategy(@Nonnull ItemOrderingStrategy<T> strategy) {
        this.checkSetterPreconditions();
        this.orderingStrategy = (ItemOrderingStrategy)Constraint.isNotNull(strategy, (String)"Item ordering strategy can not be null");
    }

    @Override
    protected void doExecute(@Nonnull @NonnullElements List<Item<T>> items) throws StageProcessingException {
        List<Item<T>> orderedItems = this.getItemOrderingStrategy().order(items);
        items.clear();
        items.addAll(orderedItems);
    }
}

