/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.metadata.pipeline;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;
import net.shibboleth.metadata.Item;
import net.shibboleth.metadata.ItemId;
import net.shibboleth.metadata.pipeline.AbstractIteratingStage;
import net.shibboleth.metadata.pipeline.StageProcessingException;
import net.shibboleth.shared.annotation.constraint.NonnullElements;
import net.shibboleth.shared.annotation.constraint.Unmodifiable;
import net.shibboleth.shared.collection.CollectionSupport;

@ThreadSafe
public class ItemIdTransformStage<T>
extends AbstractIteratingStage<T> {
    @Nonnull
    @NonnullElements
    @Unmodifiable
    @GuardedBy(value="this")
    private List<Function<String, String>> idTransformers = CollectionSupport.emptyList();

    @Nonnull
    @NonnullElements
    @Unmodifiable
    public final synchronized Collection<Function<String, String>> getIdTransformers() {
        return this.idTransformers;
    }

    public synchronized void setIdTransformers(@Nonnull @NonnullElements @Unmodifiable Collection<Function<String, String>> transformers) {
        this.checkSetterPreconditions();
        this.idTransformers = CollectionSupport.copyToList(transformers);
    }

    @Override
    protected void doExecute(@Nonnull Item<T> item) throws StageProcessingException {
        List ids = item.getItemMetadata().get(ItemId.class);
        ArrayList<ItemId> transformedIds = new ArrayList<ItemId>();
        for (ItemId id : ids) {
            for (Function<String, String> idTransform : this.getIdTransformers()) {
                String transformedId = idTransform.apply(id.getId());
                assert (transformedId != null);
                transformedIds.add(new ItemId(transformedId));
            }
        }
        item.getItemMetadata().putAll(transformedIds);
    }
}

