/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.metadata.pipeline;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.ThreadSafe;
import net.shibboleth.metadata.Item;
import net.shibboleth.metadata.ItemId;
import net.shibboleth.metadata.pipeline.MultiOutputSerializationStage;
import net.shibboleth.metadata.pipeline.StageProcessingException;
import net.shibboleth.shared.annotation.constraint.NonnullAfterInit;
import net.shibboleth.shared.component.AbstractInitializableComponent;
import net.shibboleth.shared.component.ComponentInitializationException;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.LoggerFactory;
import org.slf4j.Logger;

@ThreadSafe
public class FilesInDirectoryMultiOutputStrategy<T>
extends AbstractInitializableComponent
implements MultiOutputSerializationStage.OutputStrategy<T> {
    @Nonnull
    private static final Logger LOG = LoggerFactory.getLogger(FilesInDirectoryMultiOutputStrategy.class);
    @Nonnull
    @GuardedBy(value="this")
    private String namePrefix = "";
    @Nonnull
    @GuardedBy(value="this")
    private Function<String, String> nameTransformer = x -> x;
    @Nonnull
    @GuardedBy(value="this")
    private String nameSuffix = "";
    @NonnullAfterInit
    @GuardedBy(value="this")
    private File directory;

    @Nonnull
    public final synchronized String getNamePrefix() {
        return this.namePrefix;
    }

    public synchronized void setNamePrefix(@Nonnull String prefix) {
        this.checkSetterPreconditions();
        this.namePrefix = (String)Constraint.isNotNull((Object)prefix, (String)"name prefix may not be null");
    }

    @Nonnull
    public final synchronized Function<String, String> getNameTransformer() {
        return this.nameTransformer;
    }

    public synchronized void setNameTransformer(@Nonnull Function<String, String> transformer) {
        this.checkSetterPreconditions();
        this.nameTransformer = (Function)Constraint.isNotNull(transformer, (String)"name transformer may not be null");
    }

    @Nonnull
    public final synchronized String getNameSuffix() {
        return this.nameSuffix;
    }

    public synchronized void setNameSuffix(@Nonnull String suffix) {
        this.checkSetterPreconditions();
        this.nameSuffix = (String)Constraint.isNotNull((Object)suffix, (String)"name suffix may not be null");
    }

    @NonnullAfterInit
    public final synchronized File getDirectory() {
        return this.directory;
    }

    public synchronized void setDirectory(@Nonnull File dir) {
        this.checkSetterPreconditions();
        this.directory = (File)Constraint.isNotNull((Object)dir, (String)"directory may not be null");
    }

    @Override
    @Nonnull
    public MultiOutputSerializationStage.Destination getDestination(@Nonnull Item<T> item) throws StageProcessingException {
        List ids = item.getItemMetadata().get(ItemId.class);
        if (ids.isEmpty()) {
            throw new StageProcessingException("item has no ItemId to base a file name on");
        }
        ItemId id = (ItemId)ids.get(0);
        String name = this.getNamePrefix() + this.getNameTransformer().apply(id.getId()) + this.getNameSuffix();
        LOG.debug("id mapped {} -> {}", (Object)id.getId(), (Object)name);
        File outputFile = new File(this.getDirectory(), name);
        return new FileDestination(outputFile);
    }

    protected synchronized void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        if (this.directory == null) {
            throw new ComponentInitializationException("directory can not be null");
        }
        if (!this.directory.canWrite()) {
            throw new ComponentInitializationException("Can not write to parent directory of output files");
        }
    }

    @Immutable
    private class FileDestination
    implements MultiOutputSerializationStage.Destination {
        @Nonnull
        private final File file;

        protected FileDestination(File f) {
            this.file = f;
        }

        @Override
        public void close() throws IOException {
        }

        @Override
        @Nonnull
        public OutputStream getOutputStream() throws IOException {
            return new FileOutputStream(this.file);
        }
    }
}

