/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.metadata.dom.saml.mdattr;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import net.shibboleth.metadata.dom.saml.mdattr.AbstractEntityAttributeMatcher;
import net.shibboleth.shared.logic.Constraint;

@Immutable
public abstract class AbstractExactValueMatcher
extends AbstractEntityAttributeMatcher {
    @Nonnull
    private final String value;
    @Nonnull
    private final String name;
    @Nonnull
    private final String nameFormat;
    @Nullable
    private final String registrationAuthority;

    public AbstractExactValueMatcher(@Nonnull String matchValue, @Nonnull String matchName, @Nonnull String matchNameFormat, @Nullable String matchRegAuth) {
        this.value = (String)Constraint.isNotNull((Object)matchValue, (String)"value may not be null");
        this.name = (String)Constraint.isNotNull((Object)matchName, (String)"name may not be null");
        this.nameFormat = (String)Constraint.isNotNull((Object)matchNameFormat, (String)"name format may not be null");
        this.registrationAuthority = matchRegAuth;
    }

    @Override
    protected boolean matchAttributeValue(@Nonnull String inputValue) {
        return this.value.equals(inputValue);
    }

    @Override
    protected boolean matchAttributeName(@Nonnull String inputName) {
        return this.name.equals(inputName);
    }

    @Override
    protected boolean matchAttributeNameFormat(@Nonnull String inputNameFormat) {
        return this.nameFormat.equals(inputNameFormat);
    }

    @Override
    protected boolean matchRegistrationAuthority(@Nullable String inputRegistrationAuthority) {
        if (this.registrationAuthority == null) {
            return true;
        }
        assert (this.registrationAuthority != null);
        return this.registrationAuthority.equals(inputRegistrationAuthority);
    }
}

