/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.metadata.dom.saml;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;
import javax.xml.namespace.QName;
import net.shibboleth.metadata.dom.ElementMaker;
import net.shibboleth.metadata.dom.ElementMatcher;
import net.shibboleth.metadata.dom.SimpleElementMaker;
import net.shibboleth.metadata.dom.SimpleElementMatcher;
import net.shibboleth.metadata.dom.saml.SAMLMetadataSupport;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

@ThreadSafe
public final class SAMLSupport {
    @Nonnull
    public static final String SAML_NS = "urn:oasis:names:tc:SAML:2.0:assertion";
    @Nonnull
    public static final String SAML_PREFIX = "saml";
    @Nonnull
    public static final QName ATTRIBUTE_NAME = new QName("urn:oasis:names:tc:SAML:2.0:assertion", "Attribute", "saml");
    @Nonnull
    public static final String ATTRNAME_FORMAT_UNSPECIFIED = "urn:oasis:names:tc:SAML:2.0:attrname-format:unspecified";
    @Nonnull
    public static final QName ATTRIBUTE_VALUE_NAME = new QName("urn:oasis:names:tc:SAML:2.0:assertion", "AttributeValue", "saml");
    @Nonnull
    public static final ElementMatcher EXTENSIONS_MATCHER = new SimpleElementMatcher(SAMLMetadataSupport.EXTENSIONS_NAME);
    @Nonnull
    public static final ElementMaker EXTENSIONS_MAKER = new SimpleElementMaker(SAMLMetadataSupport.EXTENSIONS_NAME);

    private SAMLSupport() {
    }

    @Nullable
    private static Element ancestorEntity(@Nonnull Element element) {
        for (Node e = element; e != null && e.getNodeType() == 1; e = e.getParentNode()) {
            if (!SAMLMetadataSupport.isEntityDescriptor(e)) continue;
            return e;
        }
        return null;
    }

    @Nonnull
    public static String errorPrefix(@Nonnull Element element) {
        Element entity = SAMLSupport.ancestorEntity(element);
        if (entity != null) {
            Attr id = entity.getAttributeNode("ID");
            if (id != null) {
                return id.getTextContent() + ": ";
            }
            Attr entityID = entity.getAttributeNode("entityID");
            if (entityID != null) {
                return entityID.getTextContent() + ": ";
            }
        }
        return "";
    }

    @Nonnull
    public static String extractAttributeNameFormat(@Nonnull Element attribute) {
        Attr attr = attribute.getAttributeNode("NameFormat");
        if (attr == null) {
            return ATTRNAME_FORMAT_UNSPECIFIED;
        }
        String value = attr.getValue();
        assert (value != null);
        return value;
    }
}

