/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.metadata.dom.impl;

import java.io.IOException;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.X509CRL;
import java.security.cert.X509Certificate;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;
import javax.security.auth.x500.X500Principal;
import javax.xml.crypto.XMLStructure;
import javax.xml.crypto.dsig.CanonicalizationMethod;
import javax.xml.crypto.dsig.DigestMethod;
import javax.xml.crypto.dsig.Reference;
import javax.xml.crypto.dsig.SignatureMethod;
import javax.xml.crypto.dsig.SignedInfo;
import javax.xml.crypto.dsig.Transform;
import javax.xml.crypto.dsig.XMLSignature;
import javax.xml.crypto.dsig.XMLSignatureFactory;
import javax.xml.crypto.dsig.dom.DOMSignContext;
import javax.xml.crypto.dsig.keyinfo.KeyInfo;
import javax.xml.crypto.dsig.keyinfo.KeyInfoFactory;
import javax.xml.crypto.dsig.spec.DigestMethodParameterSpec;
import javax.xml.crypto.dsig.spec.ExcC14NParameterSpec;
import javax.xml.namespace.QName;
import net.shibboleth.metadata.Item;
import net.shibboleth.metadata.dom.XMLSignatureSigningStage;
import net.shibboleth.metadata.dom.ds.XMLDSIGSupport;
import net.shibboleth.metadata.pipeline.StageProcessingException;
import net.shibboleth.shared.annotation.constraint.Live;
import net.shibboleth.shared.annotation.constraint.NonnullElements;
import net.shibboleth.shared.annotation.constraint.Unmodifiable;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.StringSupport;
import net.shibboleth.shared.xml.ElementSupport;
import net.shibboleth.shared.xml.QNameSupport;
import org.slf4j.Logger;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

@NotThreadSafe
public class XMLSignatureSigner {
    @Nonnull
    private final Logger log;
    @Nonnull
    private final PrivateKey privKey;
    @Nullable
    private final PublicKey publicKey;
    @Nonnull
    @NonnullElements
    @Unmodifiable
    private final List<String> inclusivePrefixList;
    @Nonnull
    @NonnullElements
    @Unmodifiable
    private final List<QName> idAttributeNames;
    @Nonnull
    @NonnullElements
    @Unmodifiable
    private final List<String> keyNames;
    @Nonnull
    @NonnullElements
    @Unmodifiable
    private final List<X509Certificate> certificates;
    @Nonnull
    @NonnullElements
    @Unmodifiable
    private final List<X509CRL> crls;
    private final boolean includeKeyNames;
    private final boolean includeKeyValue;
    private final boolean includeX509SubjectName;
    private final boolean includeX509Certificates;
    private final boolean includeX509Crls;
    private final boolean includeX509IssuerSerial;
    private final boolean debugPreDigest;
    private final boolean removingCRsFromSignature;
    @Nonnull
    private final String c14nAlgo;
    @Nonnull
    private final String sigAlgo;
    @Nonnull
    private final String digestAlgo;
    @Nonnull
    private final XMLSignatureFactory xmlSigFactory = XMLSignatureFactory.getInstance();
    @Nonnull
    private final KeyInfoFactory keyInfoFactory = this.xmlSigFactory.getKeyInfoFactory();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public XMLSignatureSigner(@Nonnull XMLSignatureSigningStage stage, @Nonnull Logger logger) {
        this.log = logger;
        XMLSignatureSigningStage xMLSignatureSigningStage = stage;
        synchronized (xMLSignatureSigningStage) {
            boolean c14nExclusive = stage.isC14nExclusive();
            boolean c14nWithComments = stage.isC14nWithComments();
            this.c14nAlgo = c14nExclusive ? (c14nWithComments ? "http://www.w3.org/2001/10/xml-exc-c14n#WithComments" : "http://www.w3.org/2001/10/xml-exc-c14n#") : (c14nWithComments ? "http://www.w3.org/TR/2001/REC-xml-c14n-20010315#WithComments" : "http://www.w3.org/TR/2001/REC-xml-c14n-20010315");
            switch (stage.getSHAVariant()) {
                case SHA1: {
                    this.sigAlgo = "http://www.w3.org/2000/09/xmldsig#rsa-sha1";
                    this.digestAlgo = "http://www.w3.org/2000/09/xmldsig#sha1";
                    break;
                }
                case SHA384: {
                    this.sigAlgo = "http://www.w3.org/2001/04/xmldsig-more#rsa-sha384";
                    this.digestAlgo = "http://www.w3.org/2001/04/xmldsig-more#sha384";
                    break;
                }
                case SHA512: {
                    this.sigAlgo = "http://www.w3.org/2001/04/xmldsig-more#rsa-sha512";
                    this.digestAlgo = "http://www.w3.org/2001/04/xmlenc#sha512";
                    break;
                }
                default: {
                    this.sigAlgo = "http://www.w3.org/2001/04/xmldsig-more#rsa-sha256";
                    this.digestAlgo = "http://www.w3.org/2001/04/xmlenc#sha256";
                }
            }
            this.privKey = (PrivateKey)Constraint.isNotNull((Object)stage.getPrivateKey(), (String)"privateKey may not be null");
            this.publicKey = stage.getPublicKey();
            this.inclusivePrefixList = stage.getInclusivePrefixList();
            this.idAttributeNames = stage.getIdAttributeNames();
            this.keyNames = stage.getKeyNames();
            this.certificates = stage.getCertificates();
            this.crls = stage.getCrls();
            this.includeKeyNames = stage.isIncludeKeyNames();
            this.includeKeyValue = stage.isIncludeKeyValue();
            this.includeX509SubjectName = stage.isIncludeX509SubjectName();
            this.includeX509Certificates = stage.isIncludeX509Certificates();
            this.includeX509Crls = stage.isIncludeX509Crls();
            this.includeX509IssuerSerial = stage.isIncludeX509IssuerSerial();
            this.debugPreDigest = stage.isDebugPreDigest() && this.log.isDebugEnabled();
            this.removingCRsFromSignature = stage.isRemovingCRsFromSignature();
        }
    }

    public void sign(@Nonnull Item<Element> item) throws StageProcessingException {
        Element element = item.unwrap();
        Instant normStart = Instant.now();
        element.getOwnerDocument().normalizeDocument();
        Instant normEnd = Instant.now();
        this.log.debug("signature normalise time: {}", (Object)Duration.between(normStart, normEnd));
        XMLSignature signature = this.xmlSigFactory.newXMLSignature(this.buildSignedInfo(element), this.buildKeyInfo());
        DOMSignContext context = new DOMSignContext(this.privKey, (Node)element, element.getFirstChild());
        if (this.debugPreDigest) {
            context.setProperty("javax.xml.crypto.dsig.cacheReference", Boolean.TRUE);
        }
        try {
            signature.sign(context);
        }
        catch (Exception e) {
            throw new StageProcessingException("Unable to create signature for element", e);
        }
        try {
            if (this.debugPreDigest) {
                Reference ref = signature.getSignedInfo().getReferences().get(0);
                String preDigest = new String(ref.getDigestInputStream().readAllBytes(), StandardCharsets.UTF_8);
                this.log.debug("pre digest: {}", (Object)preDigest);
            }
        }
        catch (IOException e) {
            throw new StageProcessingException("Unable to log pre-digest data", e);
        }
        if (this.removingCRsFromSignature) {
            Element signatureElement = ElementSupport.getFirstChildElement((Node)element, (QName)XMLDSIGSupport.SIGNATURE_NAME);
            assert (signatureElement != null);
            this.removeCRsFromNamedChildren(signatureElement, "SignatureValue");
            this.removeCRsFromNamedChildren(signatureElement, "X509Certificate");
        }
    }

    @Nonnull
    protected SignedInfo buildSignedInfo(@Nonnull Element target) throws StageProcessingException {
        SignatureMethod sigMethod;
        CanonicalizationMethod c14nMethod;
        ExcC14NParameterSpec c14nMethodSpec = null;
        if (this.c14nAlgo.startsWith("http://www.w3.org/2001/10/xml-exc-c14n#") && this.inclusivePrefixList != null && !this.inclusivePrefixList.isEmpty()) {
            c14nMethodSpec = new ExcC14NParameterSpec(this.inclusivePrefixList);
        }
        try {
            c14nMethod = this.xmlSigFactory.newCanonicalizationMethod(this.c14nAlgo, c14nMethodSpec);
        }
        catch (Exception e) {
            String errMsg = "Unable to create transform " + this.c14nAlgo;
            throw new StageProcessingException(errMsg, e);
        }
        try {
            sigMethod = this.xmlSigFactory.newSignatureMethod(this.sigAlgo, null);
        }
        catch (Exception e) {
            String errMsg = "Unable to create signature method " + this.sigAlgo;
            throw new StageProcessingException(errMsg, e);
        }
        List<Reference> refs = Collections.singletonList(this.buildSignatureReference(target));
        SignedInfo info = this.xmlSigFactory.newSignedInfo(c14nMethod, sigMethod, refs);
        assert (info != null);
        return info;
    }

    @Nonnull
    protected Reference buildSignatureReference(@Nonnull Element target) throws StageProcessingException {
        ExcC14NParameterSpec transformSpec;
        String id = this.getElementId(target);
        Object refUri = id == null ? "" : "#" + id;
        DigestMethod digestMethod = null;
        try {
            DigestMethodParameterSpec digestMethodSpec = null;
            digestMethod = this.xmlSigFactory.newDigestMethod(this.digestAlgo, digestMethodSpec);
        }
        catch (Exception e) {
            String errMsg = "Unable to create digest method " + this.digestAlgo;
            throw new StageProcessingException(errMsg, e);
        }
        ArrayList<Transform> transforms = new ArrayList<Transform>();
        try {
            transformSpec = null;
            transforms.add(this.xmlSigFactory.newTransform("http://www.w3.org/2000/09/xmldsig#enveloped-signature", transformSpec));
        }
        catch (Exception e) {
            String errMsg = "Unable to create transform http://www.w3.org/2000/09/xmldsig#enveloped-signature";
            throw new StageProcessingException("Unable to create transform http://www.w3.org/2000/09/xmldsig#enveloped-signature", e);
        }
        try {
            if (this.c14nAlgo.startsWith("http://www.w3.org/2001/10/xml-exc-c14n#") && this.inclusivePrefixList != null && !this.inclusivePrefixList.isEmpty()) {
                transformSpec = new ExcC14NParameterSpec(this.inclusivePrefixList);
            }
            transforms.add(this.xmlSigFactory.newTransform(this.c14nAlgo, transformSpec));
        }
        catch (Exception e) {
            String errMsg = "Unable to create transform " + this.c14nAlgo;
            throw new StageProcessingException(errMsg, e);
        }
        Reference ref = this.xmlSigFactory.newReference((String)refUri, digestMethod, transforms, null, null);
        assert (ref != null);
        return ref;
    }

    @Nullable
    protected String getElementId(@Nonnull Element target) {
        String value;
        Attr attribute;
        int i;
        NamedNodeMap attributes = target.getAttributes();
        if (attributes == null || attributes.getLength() < 1) {
            return null;
        }
        if (this.idAttributeNames != null && !this.idAttributeNames.isEmpty()) {
            for (i = 0; i < attributes.getLength(); ++i) {
                attribute = (Attr)attributes.item(i);
                assert (attribute != null);
                if (!this.idAttributeNames.contains(QNameSupport.getNodeQName((Node)attribute))) continue;
                target.setIdAttributeNode(attribute, true);
                value = StringSupport.trimOrNull((String)attribute.getValue());
                if (value == null) continue;
                return value;
            }
        }
        for (i = 0; i < attributes.getLength(); ++i) {
            attribute = (Attr)attributes.item(i);
            if (!attribute.isId() || (value = StringSupport.trimOrNull((String)attribute.getValue())) == null) continue;
            return value;
        }
        return null;
    }

    @Nullable
    protected KeyInfo buildKeyInfo() throws StageProcessingException {
        ArrayList<XMLStructure> keyInfoItems = new ArrayList<XMLStructure>();
        this.addKeyNames(keyInfoItems);
        this.addKeyValue(keyInfoItems);
        this.addX509Data(keyInfoItems);
        if (keyInfoItems.isEmpty()) {
            return null;
        }
        return this.keyInfoFactory.newKeyInfo(keyInfoItems);
    }

    protected void addKeyNames(@Nonnull @NonnullElements @Live List<XMLStructure> keyInfoItems) throws StageProcessingException {
        if (!this.includeKeyNames) {
            return;
        }
        if (this.keyNames != null && !this.keyNames.isEmpty()) {
            for (String name : this.keyNames) {
                keyInfoItems.add(this.keyInfoFactory.newKeyName(name));
            }
        }
    }

    protected void addKeyValue(@Nonnull @NonnullElements @Live List<XMLStructure> keyInfoItems) throws StageProcessingException {
        if (!this.includeKeyValue) {
            return;
        }
        PublicKey key = this.publicKey;
        if (key == null && !this.certificates.isEmpty()) {
            key = this.certificates.get(0).getPublicKey();
        }
        if (key != null) {
            try {
                keyInfoItems.add(this.keyInfoFactory.newKeyValue(key));
            }
            catch (Exception e) {
                throw new StageProcessingException("Unable to create KeyValue", e);
            }
        }
    }

    protected void addX509Data(@Nonnull @NonnullElements @Live List<XMLStructure> keyInfoItems) {
        ArrayList<Object> x509Data = new ArrayList<Object>();
        if (this.certificates != null && !this.certificates.isEmpty()) {
            X509Certificate endEntityCert = this.certificates.get(0);
            if (this.includeX509SubjectName) {
                X500Principal subjectDn = endEntityCert.getSubjectX500Principal();
                x509Data.add(subjectDn.getName("RFC2253"));
            }
            if (this.includeX509Certificates) {
                x509Data.addAll(this.certificates);
            }
            if (this.includeX509IssuerSerial) {
                X500Principal issuerDn = endEntityCert.getIssuerX500Principal();
                BigInteger serialNumber = endEntityCert.getSerialNumber();
                x509Data.add(this.keyInfoFactory.newX509IssuerSerial(issuerDn.getName("RFC2253"), serialNumber));
            }
        }
        if (this.includeX509Crls && this.crls != null && !this.crls.isEmpty()) {
            x509Data.add(this.crls);
        }
        if (!x509Data.isEmpty()) {
            keyInfoItems.add(this.keyInfoFactory.newX509Data(x509Data));
        }
    }

    private void removeCRsFromNamedChildren(@Nonnull Element signature, @Nonnull String elementName) {
        NodeList nodes = signature.getElementsByTagNameNS("http://www.w3.org/2000/09/xmldsig#", elementName);
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node node = nodes.item(i);
            String text = node.getTextContent();
            if (text.indexOf(13) < 0) continue;
            node.setTextContent(text.replaceAll("\\r", ""));
        }
    }
}

