/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.metadata.dom;

import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;
import javax.xml.namespace.NamespaceContext;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import net.shibboleth.metadata.Item;
import net.shibboleth.metadata.dom.SimpleNamespaceContext;
import net.shibboleth.shared.annotation.constraint.NotEmpty;
import net.shibboleth.shared.primitive.LoggerFactory;
import org.slf4j.Logger;
import org.w3c.dom.Element;

@ThreadSafe
public class XPathItemSelectionStrategy
implements Predicate<Item<Element>> {
    @Nonnull
    private static final Logger LOG = LoggerFactory.getLogger(XPathItemSelectionStrategy.class);
    @Nonnull
    @GuardedBy(value="this")
    private final XPathExpression compiledExpression;

    public XPathItemSelectionStrategy(@Nonnull @NotEmpty String expression, @Nullable NamespaceContext context) throws XPathExpressionException {
        NamespaceContext namespaceContext = context == null ? new SimpleNamespaceContext() : context;
        XPathFactory factory = XPathFactory.newInstance();
        XPath xpath = factory.newXPath();
        xpath.setNamespaceContext(namespaceContext);
        XPathExpression compiled = xpath.compile(expression);
        assert (compiled != null);
        this.compiledExpression = compiled;
    }

    @Override
    public synchronized boolean test(Item<Element> item) {
        try {
            return this.compiledExpression.evaluateExpression(item.unwrap(), Boolean.class);
        }
        catch (XPathExpressionException e) {
            LOG.warn("Exception thrown during XPath evaluation: " + String.valueOf(e));
            return false;
        }
    }
}

