/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.metadata.dom;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.metadata.dom.ElementMaker;
import net.shibboleth.metadata.dom.ElementMatcher;
import net.shibboleth.shared.annotation.constraint.NonnullElements;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.xml.ElementSupport;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

public class Container {
    @Nonnull
    public static final ChildAddingStrategy FIRST_CHILD = new ChildAddingStrategy(){

        @Override
        @Nonnull
        public Container addChild(@Nonnull Container parent, @Nonnull Element child) {
            Element parentElement = parent.unwrap();
            String indent = "\n" + parent.indentInner;
            Text indentNode = parentElement.getOwnerDocument().createTextNode(indent);
            parent.prime();
            parentElement.insertBefore(child, parentElement.getFirstChild());
            parentElement.insertBefore(indentNode, parentElement.getFirstChild());
            return new Container(child, parent);
        }
    };
    @Nonnull
    public static final ChildAddingStrategy LAST_CHILD = new ChildAddingStrategy(){

        @Override
        @Nonnull
        public Container addChild(@Nonnull Container parent, @Nonnull Element child) {
            Element parentElement = parent.unwrap();
            Document document = parentElement.getOwnerDocument();
            parent.prime();
            parentElement.appendChild(document.createTextNode(parent.indentStep));
            parentElement.appendChild(child);
            parentElement.appendChild(document.createTextNode("\n" + parent.indentOuter));
            return new Container(child, parent);
        }
    };
    @Nonnull
    private static final String DEFAULT_INDENT = "    ";
    @Nonnull
    private final Element element;
    @Nullable
    private final Container parentContainer;
    @Nonnull
    private final String indentOuter;
    @Nonnull
    private final String indentInner;
    @Nonnull
    private final String indentStep;

    private Container(@Nonnull Element elem, @Nullable Container parent, @Nonnull String outer, @Nonnull String inner, @Nonnull String step) {
        this.element = (Element)Constraint.isNotNull((Object)elem, (String)"element must not be null");
        this.parentContainer = parent;
        this.indentOuter = (String)Constraint.isNotNull((Object)outer, (String)"outer indent must not be null");
        this.indentInner = (String)Constraint.isNotNull((Object)inner, (String)"inner indent must not be null");
        this.indentStep = (String)Constraint.isNotNull((Object)step, (String)"indent step must not be null");
    }

    private Container(@Nonnull Element child, @Nonnull Container parent) {
        this(child, parent, parent.indentInner, parent.indentInner + parent.indentStep, parent.indentStep);
    }

    public Container(@Nonnull Element root) {
        this(root, null, "", DEFAULT_INDENT, DEFAULT_INDENT);
    }

    @Nullable
    public Container getParent() {
        return this.parentContainer;
    }

    @Nonnull
    public Element unwrap() {
        return this.element;
    }

    public void setText(@Nonnull String text) {
        Constraint.isNotNull((Object)text, (String)"text content must not be null");
        this.element.setTextContent(text);
    }

    public void prime() {
        if (!this.element.hasChildNodes()) {
            this.setText("\n" + this.indentOuter);
        }
    }

    @Nullable
    public Container findChild(@Nonnull ElementMatcher matcher) {
        for (Element e : ElementSupport.getChildElements((Node)this.element)) {
            assert (e != null);
            if (!matcher.match(e)) continue;
            return new Container(e, this);
        }
        return null;
    }

    @Nonnull
    @NonnullElements
    public List<Container> findChildren(@Nonnull ElementMatcher matcher) {
        ArrayList<Container> list = new ArrayList<Container>();
        for (Element e : ElementSupport.getChildElements((Node)this.element)) {
            assert (e != null);
            if (!matcher.match(e)) continue;
            list.add(new Container(e, this));
        }
        return list;
    }

    @Nonnull
    public Container addChild(@Nonnull Element child, @Nonnull ChildAddingStrategy adder) {
        return adder.addChild(this, child);
    }

    @Nonnull
    public Container addChild(@Nonnull ElementMaker maker, @Nonnull ChildAddingStrategy adder) {
        Element child = maker.make(this);
        assert (child != null);
        return this.addChild(child, adder);
    }

    @Nonnull
    public Container locateChild(@Nonnull ElementMatcher matcher, @Nonnull ElementMaker maker, @Nonnull ChildAddingStrategy adder) {
        Container existing = this.findChild(matcher);
        if (existing != null) {
            return existing;
        }
        return this.addChild(maker, adder);
    }

    public static interface ChildAddingStrategy {
        @Nonnull
        public Container addChild(@Nonnull Container var1, @Nonnull Element var2);
    }
}

