/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.metadata.dom;

import java.util.Collection;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.GuardedBy;
import javax.xml.namespace.QName;
import net.shibboleth.metadata.Item;
import net.shibboleth.metadata.dom.AbstractDOMValidationStage;
import net.shibboleth.metadata.dom.DOMTraversalContext;
import net.shibboleth.metadata.dom.SimpleDOMTraversalContext;
import net.shibboleth.shared.annotation.constraint.NonnullElements;
import net.shibboleth.shared.annotation.constraint.Unmodifiable;
import net.shibboleth.shared.collection.CollectionSupport;
import net.shibboleth.shared.component.ComponentInitializationException;
import net.shibboleth.shared.logic.Constraint;
import org.w3c.dom.Element;

public abstract class AbstractElementVisitingValidationStage<V, N>
extends AbstractDOMValidationStage<V, DOMTraversalContext> {
    @Nonnull
    @NonnullElements
    @Unmodifiable
    @GuardedBy(value="this")
    private Set<QName> elementNames = CollectionSupport.emptySet();

    @Nonnull
    public final synchronized Collection<QName> getElementNames() {
        return this.elementNames;
    }

    public final synchronized void setElementNames(@Nonnull Collection<QName> names) {
        this.checkSetterPreconditions();
        Constraint.isNotNull(names, (String)"elementNames may not be null");
        this.elementNames = CollectionSupport.copyToSet(names);
    }

    public final synchronized void setElementName(@Nonnull QName name) {
        this.checkSetterPreconditions();
        Constraint.isNotNull((Object)name, (String)"elementName may not be null");
        this.elementNames = CollectionSupport.setOf((Object)name);
    }

    @Override
    @Nonnull
    protected DOMTraversalContext buildContext(@Nonnull Item<Element> item) {
        return new SimpleDOMTraversalContext(item);
    }

    @Override
    protected boolean applicable(@Nonnull Element e, @Nonnull DOMTraversalContext context) {
        QName q = new QName(e.getNamespaceURI(), e.getLocalName());
        return this.getElementNames().contains(q);
    }

    @Nonnull
    protected abstract V convert(@Nonnull N var1);

    @Override
    protected synchronized void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        if (this.elementNames.isEmpty()) {
            throw new ComponentInitializationException("elementNames may not be empty");
        }
    }
}

