/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.metadata.dom;

import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.ThreadSafe;
import net.shibboleth.metadata.dom.AbstractDOMTraversalStage;
import net.shibboleth.metadata.dom.DOMTraversalContext;
import net.shibboleth.metadata.pipeline.StageProcessingException;
import net.shibboleth.metadata.validate.Validator;
import net.shibboleth.metadata.validate.ValidatorSequence;
import net.shibboleth.shared.annotation.constraint.NonnullElements;
import net.shibboleth.shared.annotation.constraint.Unmodifiable;
import net.shibboleth.shared.component.ComponentInitializationException;

@ThreadSafe
public abstract class AbstractDOMValidationStage<V, C extends DOMTraversalContext>
extends AbstractDOMTraversalStage<C> {
    @Nonnull
    @NonnullElements
    @Unmodifiable
    private final ValidatorSequence<V> validators = new ValidatorSequence();

    public void setValidators(@Nonnull @NonnullElements @Unmodifiable List<Validator<V>> newValidators) {
        this.validators.setValidators(newValidators);
    }

    @Nonnull
    @NonnullElements
    @Unmodifiable
    public final List<Validator<V>> getValidators() {
        return this.validators.getValidators();
    }

    protected void applyValidators(@Nonnull V obj, @Nonnull C context) throws StageProcessingException {
        String myId = this.getId();
        assert (myId != null);
        this.validators.validate(obj, context.getItem(), myId);
    }

    protected void doDestroy() {
        this.validators.destroy();
        super.doDestroy();
    }

    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        String myId = this.getId();
        assert (myId != null);
        this.validators.setId(myId);
        this.validators.initialize();
    }
}

