/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.shared.spring.servlet.impl;

import jakarta.servlet.GenericServlet;
import jakarta.servlet.Servlet;
import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import java.io.IOException;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.shared.annotation.constraint.NotEmpty;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.StringSupport;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;

public class DelegatingServletProxy
extends GenericServlet {
    private static final long serialVersionUID = 5470308159110258401L;
    @Nullable
    @NotEmpty
    private String contextAttribute;
    @Nullable
    private WebApplicationContext webApplicationContext;
    @Nullable
    @NotEmpty
    private String targetBeanName;
    private boolean targetFilterLifecycle;
    @Nullable
    private volatile Servlet delegate;
    @Nonnull
    private Object delegateMonitor = new Object();

    public DelegatingServletProxy() {
    }

    public DelegatingServletProxy(@Nonnull Servlet del) {
        this.delegate = (Servlet)Constraint.isNotNull((Object)del, (String)"Delegate servlet cannot be null");
    }

    public DelegatingServletProxy(@Nonnull @NotEmpty String targetBeanName) {
        this(targetBeanName, null);
    }

    public DelegatingServletProxy(@Nonnull @NotEmpty String targetBeanName, @Nullable WebApplicationContext wac) {
        this.setTargetBeanName(targetBeanName);
        this.webApplicationContext = wac;
    }

    public void setContextAttribute(@Nullable @NotEmpty String name) {
        this.contextAttribute = StringSupport.trimOrNull((String)name);
    }

    @Nullable
    @NotEmpty
    public String getContextAttribute() {
        return this.contextAttribute;
    }

    public void setTargetBeanName(@Nullable @NotEmpty String name) {
        this.targetBeanName = StringSupport.trimOrNull((String)name);
    }

    @Nullable
    @NotEmpty
    protected String getTargetBeanName() {
        return this.targetBeanName;
    }

    public void setTargetFilterLifecycle(boolean flag) {
        this.targetFilterLifecycle = flag;
    }

    protected boolean isTargetFilterLifecycle() {
        return this.targetFilterLifecycle;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init() throws ServletException {
        Object object = this.delegateMonitor;
        synchronized (object) {
            if (this.delegate == null) {
                WebApplicationContext wac;
                if (this.targetBeanName == null) {
                    this.targetBeanName = this.getServletName();
                }
                if ((wac = this.findWebApplicationContext()) != null) {
                    this.delegate = this.initDelegate(wac);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void service(ServletRequest request, ServletResponse response) throws ServletException, IOException {
        Servlet delegateToUse = this.delegate;
        if (delegateToUse == null) {
            Object object = this.delegateMonitor;
            synchronized (object) {
                delegateToUse = this.delegate;
                if (delegateToUse == null) {
                    WebApplicationContext wac = this.findWebApplicationContext();
                    if (wac == null) {
                        throw new IllegalStateException("No WebApplicationContext found: no ContextLoaderListener or DispatcherServlet registered?");
                    }
                    delegateToUse = this.initDelegate(wac);
                }
                this.delegate = delegateToUse;
            }
        }
        this.invokeDelegate(delegateToUse, request, response);
    }

    public void destroy() {
        Servlet delegateToUse = this.delegate;
        if (delegateToUse != null) {
            this.destroyDelegate(delegateToUse);
        }
    }

    @Nullable
    protected WebApplicationContext findWebApplicationContext() {
        if (this.webApplicationContext != null) {
            ConfigurableApplicationContext cac;
            WebApplicationContext webApplicationContext = this.webApplicationContext;
            if (webApplicationContext instanceof ConfigurableApplicationContext && !(cac = (ConfigurableApplicationContext)webApplicationContext).isActive()) {
                cac.refresh();
            }
            return this.webApplicationContext;
        }
        String attrName = this.getContextAttribute();
        if (attrName != null) {
            return WebApplicationContextUtils.getWebApplicationContext((ServletContext)this.getServletContext(), (String)attrName);
        }
        return WebApplicationContextUtils.findWebApplicationContext((ServletContext)this.getServletContext());
    }

    @Nonnull
    protected Servlet initDelegate(@Nonnull WebApplicationContext wac) throws ServletException {
        String targetBean = this.getTargetBeanName();
        if (targetBean == null) {
            throw new ServletException("No target bean name set.");
        }
        Servlet del = (Servlet)wac.getBean(targetBean, Servlet.class);
        if (this.isTargetFilterLifecycle()) {
            del.init(this.getServletConfig());
        }
        return del;
    }

    protected void invokeDelegate(@Nonnull Servlet del, @Nonnull ServletRequest request, @Nonnull ServletResponse response) throws ServletException, IOException {
        del.service(request, response);
    }

    protected void destroyDelegate(@Nonnull Servlet del) {
        if (this.isTargetFilterLifecycle()) {
            del.destroy();
        }
    }
}

