/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.shared.spring.expression;

import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.shared.annotation.ParameterName;
import net.shibboleth.shared.annotation.constraint.NotEmpty;
import net.shibboleth.shared.primitive.LoggerFactory;
import net.shibboleth.shared.spring.expression.AbstractSpringExpressionEvaluator;
import org.slf4j.Logger;
import org.springframework.expression.EvaluationContext;

public class SpringExpressionConsumer<T>
extends AbstractSpringExpressionEvaluator
implements Consumer<T> {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(SpringExpressionConsumer.class);
    @Nullable
    private Class<T> inputTypeClass;

    public SpringExpressionConsumer(@Nonnull @ParameterName(name="expression") @NotEmpty String expression) {
        super(expression);
    }

    @Nullable
    public Class<T> getInputType() {
        return this.inputTypeClass;
    }

    public void setInputType(@Nullable Class<T> type) {
        this.inputTypeClass = type;
    }

    @Override
    public void accept(@Nullable T input) {
        Class<T> itype = this.getInputType();
        if (null != itype && null != input && !itype.isInstance(input)) {
            this.log.error("Input of type {} was not of type {}", input.getClass(), itype);
        } else {
            this.evaluate(input);
        }
    }

    @Override
    protected void prepareContext(@Nonnull EvaluationContext context, Object ... input) {
        context.setVariable("input", input != null ? input[0] : null);
    }
}

