/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.shared.spring.config;

import java.util.function.Predicate;
import javax.annotation.Nonnull;
import net.shibboleth.shared.logic.PredicateSupport;
import net.shibboleth.shared.primitive.LoggerFactory;
import net.shibboleth.shared.primitive.StringSupport;
import org.slf4j.Logger;
import org.springframework.core.convert.converter.Converter;

public class StringBooleanToPredicateConverter
implements Converter<String, Predicate<?>> {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(StringBooleanToPredicateConverter.class);

    public Predicate<?> convert(@Nonnull String source) {
        String trimmed = StringSupport.trimOrNull((String)source);
        if (Boolean.valueOf(trimmed).booleanValue()) {
            return PredicateSupport.alwaysTrue();
        }
        if (trimmed != null) {
            if ("1".equals(trimmed)) {
                this.log.warn("The value '1' is not treated as 'true'; if intentional, explicitly use 'false'");
            } else if (!"false".equalsIgnoreCase(trimmed) && !"0".equals(trimmed)) {
                this.log.warn("Unrecognized value '{}' converted to false; if intentional, explicitly use 'false'", (Object)trimmed);
            }
        }
        return PredicateSupport.alwaysFalse();
    }
}

