/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.metadata.dom.saml.mdui;

import javax.annotation.Nonnull;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;
import javax.xml.namespace.QName;
import net.shibboleth.metadata.Item;
import net.shibboleth.metadata.dom.AbstractDOMTraversalStage;
import net.shibboleth.metadata.dom.DOMTraversalContext;
import net.shibboleth.metadata.dom.SimpleDOMTraversalContext;
import net.shibboleth.metadata.dom.saml.mdui.MDUISupport;
import net.shibboleth.shared.net.IPRange;
import net.shibboleth.shared.xml.ElementSupport;
import org.w3c.dom.Element;

@ThreadSafe
public class IPHintValidationStage
extends AbstractDOMTraversalStage<DOMTraversalContext> {
    @GuardedBy(value="this")
    private boolean checkingNetworks = true;

    public final synchronized boolean isCheckingNetworks() {
        return this.checkingNetworks;
    }

    public synchronized void setCheckingNetworks(boolean check) {
        this.checkSetterPreconditions();
        this.checkingNetworks = check;
    }

    @Override
    protected boolean applicable(@Nonnull Element element, @Nonnull DOMTraversalContext context) {
        return ElementSupport.isElementNamed((Element)element, (QName)MDUISupport.IPHINT_NAME);
    }

    @Override
    protected void visit(@Nonnull Element ipHint, @Nonnull DOMTraversalContext context) {
        String hint = ipHint.getTextContent();
        assert (hint != null);
        try {
            IPRange range = IPRange.parseCIDRBlock((String)hint);
            if (this.isCheckingNetworks() && range.getHostAddress() != null) {
                this.addError(context.getItem(), ipHint, "invalid IPHint '" + hint + "': CIDR notation represents a host, not a network");
            }
        }
        catch (IllegalArgumentException e) {
            this.addError(context.getItem(), ipHint, "invalid IPHint '" + hint + "': " + e.getMessage());
        }
    }

    @Override
    @Nonnull
    protected DOMTraversalContext buildContext(@Nonnull Item<Element> item) {
        return new SimpleDOMTraversalContext(item);
    }
}

