/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.metadata.dom.saml;

import java.time.Duration;
import java.time.Instant;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;
import javax.xml.namespace.QName;
import net.shibboleth.metadata.Item;
import net.shibboleth.metadata.dom.saml.SAMLMetadataSupport;
import net.shibboleth.metadata.pipeline.AbstractIteratingStage;
import net.shibboleth.metadata.pipeline.StageProcessingException;
import net.shibboleth.shared.annotation.constraint.NonnullAfterInit;
import net.shibboleth.shared.component.ComponentInitializationException;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.xml.AttributeSupport;
import org.w3c.dom.Element;

@ThreadSafe
public class SetValidUntilStage
extends AbstractIteratingStage<Element> {
    @NonnullAfterInit
    @GuardedBy(value="this")
    private Duration validityDuration;

    @NonnullAfterInit
    public final synchronized Duration getValidityDuration() {
        return this.validityDuration;
    }

    public synchronized void setValidityDuration(@Nonnull Duration duration) {
        this.checkSetterPreconditions();
        Constraint.isNotNull((Object)duration, (String)"validity duration cannot be null");
        Constraint.isFalse((boolean)duration.isZero(), (String)"validity duration cannot be zero");
        Constraint.isFalse((boolean)duration.isNegative(), (String)"validity duration cannot be negative");
        this.validityDuration = duration;
    }

    @Override
    protected void doExecute(@Nonnull Item<Element> item) throws StageProcessingException {
        Element descriptor = item.unwrap();
        if (SAMLMetadataSupport.isEntityOrEntitiesDescriptor(descriptor)) {
            AttributeSupport.removeAttribute((Element)descriptor, (QName)SAMLMetadataSupport.VALID_UNTIL_ATTRIB_NAME);
            Instant until = Instant.now().plus(this.getValidityDuration());
            assert (until != null);
            AttributeSupport.appendDateTimeAttribute((Element)descriptor, (QName)SAMLMetadataSupport.VALID_UNTIL_ATTRIB_NAME, (Instant)until);
        }
    }

    protected synchronized void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        if (this.validityDuration == null) {
            throw new ComponentInitializationException("validity duration must be set");
        }
    }
}

