/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.metadata.dom.saml;

import javax.annotation.Nonnull;
import javax.annotation.concurrent.Immutable;
import net.shibboleth.metadata.dom.Container;
import net.shibboleth.metadata.dom.SimpleElementMaker;
import net.shibboleth.metadata.dom.saml.SAMLSupport;
import net.shibboleth.shared.logic.Constraint;
import org.w3c.dom.Element;

@Immutable
public class AttributeElementMaker
extends SimpleElementMaker {
    @Nonnull
    private final String attributeName;
    @Nonnull
    private final String attributeNameFormat;

    public AttributeElementMaker(@Nonnull String name, @Nonnull String nameFormat) {
        super(SAMLSupport.ATTRIBUTE_NAME);
        this.attributeName = (String)Constraint.isNotNull((Object)name, (String)"attribute name must not be null");
        this.attributeNameFormat = (String)Constraint.isNotNull((Object)nameFormat, (String)"attribute name format must not be null");
    }

    @Override
    @Nonnull
    public Element make(@Nonnull Container container) {
        Element newElement = super.make(container);
        newElement.setAttributeNS(null, "Name", this.attributeName);
        newElement.setAttributeNS(null, "NameFormat", this.attributeNameFormat);
        return newElement;
    }
}

