/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.metadata.validate.x509;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.cert.X509Certificate;
import java.security.interfaces.RSAPublicKey;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;
import net.shibboleth.metadata.Item;
import net.shibboleth.metadata.pipeline.StageProcessingException;
import net.shibboleth.metadata.validate.x509.AbstractX509Validator;
import net.shibboleth.shared.annotation.constraint.NonnullAfterInit;
import net.shibboleth.shared.component.ComponentInitializationException;
import net.shibboleth.shared.logic.Constraint;
import org.apache.commons.codec.binary.Hex;
import org.springframework.core.io.Resource;

@ThreadSafe
public class X509RSAOpenSSLKeylistValidator
extends AbstractX509Validator {
    private static final byte[] OPEN_SSL_PREFIX = new byte[]{77, 111, 100, 117, 108, 117, 115, 61};
    @NonnullAfterInit
    @GuardedBy(value="this")
    private Resource keylistResource;
    @GuardedBy(value="this")
    private int keySize;
    @Nonnull
    @GuardedBy(value="this")
    private final Set<String> digestValues = new HashSet<String>();

    @NonnullAfterInit
    public final synchronized Resource getKeylistResource() {
        return this.keylistResource;
    }

    public synchronized void setKeylistResource(@Nonnull Resource resource) {
        this.checkSetterPreconditions();
        this.keylistResource = (Resource)Constraint.isNotNull((Object)resource, (String)"keylist resource can not be null");
    }

    public synchronized void setKeySize(int size) {
        this.keySize = size;
    }

    public final synchronized int getKeySize() {
        return this.keySize;
    }

    @Nonnull
    private String openSSLDigest(@Nonnull BigInteger modulus) throws StageProcessingException {
        try {
            byte[] modulusBytes = modulus.toByteArray();
            if (modulusBytes[0] == 0) {
                modulusBytes = Arrays.copyOfRange(modulusBytes, 1, modulusBytes.length);
            }
            char[] encodedModulus = Hex.encodeHex((byte[])modulusBytes, (boolean)false);
            ByteArrayOutputStream bb = new ByteArrayOutputStream();
            try {
                bb.write(OPEN_SSL_PREFIX);
                for (char c : encodedModulus) {
                    bb.write((byte)c);
                }
                bb.write(10);
            }
            catch (IOException e) {
                throw new StageProcessingException("internal error writing to ByteArrayStream", e);
            }
            MessageDigest digest = MessageDigest.getInstance("SHA1");
            digest.update(bb.toByteArray());
            byte[] bytes = digest.digest();
            char[] encodedDigest = Hex.encodeHex((byte[])bytes, (boolean)true);
            String strValue = String.valueOf(encodedDigest);
            String trimmed = strValue.substring(20);
            assert (trimmed != null);
            return trimmed;
        }
        catch (NoSuchAlgorithmException e) {
            throw new StageProcessingException("could not create message digester", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doValidate(@Nonnull X509Certificate cert, @Nonnull Item<?> item, @Nonnull String callerId) throws StageProcessingException {
        this.checkComponentActive();
        PublicKey key = cert.getPublicKey();
        if ("RSA".equals(key.getAlgorithm())) {
            String value;
            int keySz;
            Set<String> values;
            RSAPublicKey rsaKey = (RSAPublicKey)key;
            BigInteger modulus = rsaKey.getModulus();
            assert (modulus != null);
            X509RSAOpenSSLKeylistValidator x509RSAOpenSSLKeylistValidator = this;
            synchronized (x509RSAOpenSSLKeylistValidator) {
                values = this.digestValues;
                keySz = this.keySize;
            }
            if ((keySz == 0 || keySz == modulus.bitLength()) && values.contains(value = this.openSSLDigest(modulus))) {
                this.addError("RSA modulus included in key list (" + value + ")", item, callerId);
            }
        }
    }

    protected void doDestroy() {
        this.digestValues.clear();
        super.doDestroy();
    }

    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        if (this.keylistResource == null) {
            throw new ComponentInitializationException("Unable to initialize " + this.getId() + ", keylistResource must not be null");
        }
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(this.keylistResource.getInputStream(), StandardCharsets.UTF_8));){
            String line;
            while ((line = reader.readLine()) != null) {
                if (line.trim().length() == 0 || line.charAt(0) == '#') continue;
                this.digestValues.add(line);
            }
        }
        catch (IOException e) {
            throw new ComponentInitializationException("Unable to initialize " + this.getId() + ", error reading keylistResource " + this.keylistResource.getDescription() + " information", (Exception)e);
        }
    }
}

