/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.metadata.validate.string;

import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;
import net.shibboleth.metadata.validate.BaseValidator;
import net.shibboleth.shared.annotation.constraint.NonnullAfterInit;
import net.shibboleth.shared.component.ComponentInitializationException;

@ThreadSafe
public abstract class BaseStringRegexValidator
extends BaseValidator {
    @NonnullAfterInit
    @GuardedBy(value="this")
    private String regex;
    @NonnullAfterInit
    @GuardedBy(value="this")
    private Pattern pattern;

    @NonnullAfterInit
    public final synchronized String getRegex() {
        return this.regex;
    }

    public synchronized void setRegex(@Nonnull String r) {
        this.checkSetterPreconditions();
        this.regex = r;
    }

    protected final synchronized Pattern getPattern() {
        return this.pattern;
    }

    protected synchronized void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        if (this.getRegex() == null) {
            throw new ComponentInitializationException("regular expression to be matched can not be null");
        }
        this.pattern = Pattern.compile(this.getRegex());
    }
}

