/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.metadata.validate.string;

import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import javax.annotation.Nonnull;
import net.shibboleth.metadata.validate.BaseAsValidator;
import net.shibboleth.metadata.validate.Validator;

public class AsURLStringValidator
extends BaseAsValidator<String, URL>
implements Validator<String> {
    @Override
    @Nonnull
    protected URL convert(@Nonnull String value) throws IllegalArgumentException {
        try {
            URI uri = new URI(value);
            URL result = uri.toURL();
            assert (result != null);
            return result;
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException(e.getMessage(), e);
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException(e.getMessage(), e);
        }
        catch (IllegalArgumentException e) {
            throw e;
        }
    }
}

