/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.metadata.pipeline.impl;

import java.util.List;
import java.util.concurrent.Callable;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.Immutable;
import net.shibboleth.metadata.Item;
import net.shibboleth.metadata.pipeline.Pipeline;
import net.shibboleth.metadata.pipeline.PipelineProcessingException;
import net.shibboleth.shared.annotation.constraint.NonnullElements;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.LoggerFactory;
import org.slf4j.Logger;

@Immutable
public class PipelineCallable<T>
implements Callable<List<Item<T>>> {
    @Nonnull
    private static final Logger LOG = LoggerFactory.getLogger(PipelineCallable.class);
    @Nonnull
    private final Pipeline<T> thePipeline;
    @Nonnull
    @NonnullElements
    private final List<Item<T>> theItems;

    public PipelineCallable(@Nonnull Pipeline<T> pipeline, @Nonnull @NonnullElements List<Item<T>> items) {
        this.thePipeline = (Pipeline)Constraint.isNotNull(pipeline, (String)"To-be-invoked pipeline can not be null");
        Constraint.isTrue((boolean)pipeline.isInitialized(), (String)"To-be-invoked pipeline must be initialized");
        this.theItems = (List)Constraint.isNotNull(items, (String)"Item collection can not be null");
    }

    @Override
    @Nonnull
    @NonnullElements
    public List<Item<T>> call() throws PipelineProcessingException {
        LOG.debug("Executing pipeline {} on an item collection containing {} items", (Object)this.thePipeline.getId(), (Object)this.theItems.size());
        this.thePipeline.execute(this.theItems);
        return this.theItems;
    }
}

