/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.metadata.pipeline;

import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.ThreadSafe;
import net.shibboleth.metadata.ErrorStatus;
import net.shibboleth.metadata.InfoStatus;
import net.shibboleth.metadata.Item;
import net.shibboleth.metadata.StatusMetadata;
import net.shibboleth.metadata.WarningStatus;
import net.shibboleth.metadata.pipeline.AbstractItemMetadataSelectionStage;
import net.shibboleth.metadata.pipeline.StageProcessingException;
import net.shibboleth.shared.annotation.constraint.NonnullElements;
import net.shibboleth.shared.collection.ClassToInstanceMultiMap;
import net.shibboleth.shared.primitive.LoggerFactory;
import org.slf4j.Logger;

@ThreadSafe
public class StatusMetadataLoggingStage<T>
extends AbstractItemMetadataSelectionStage<T, StatusMetadata> {
    @Nonnull
    private static final Logger LOG = LoggerFactory.getLogger(StatusMetadataLoggingStage.class);

    @Override
    protected void doExecute(@Nonnull @NonnullElements List<Item<T>> items, @Nonnull Item<T> matchingItem, @Nonnull @NonnullElements ClassToInstanceMultiMap<StatusMetadata> matchingMetadata) throws StageProcessingException {
        String itemId = this.getItemIdentificationStrategy().getItemIdentifier(matchingItem);
        this.logInfos(itemId, matchingMetadata.get(InfoStatus.class));
        this.logWarnings(itemId, matchingMetadata.get(WarningStatus.class));
        this.logErrors(itemId, matchingMetadata.get(ErrorStatus.class));
    }

    private void logInfos(@Nonnull String itemId, @Nonnull @NonnullElements List<InfoStatus> statuses) {
        if (!statuses.isEmpty() && LOG.isInfoEnabled()) {
            LOG.info("Item {} was marked with the following Info status messages", (Object)itemId);
            for (InfoStatus status : statuses) {
                LOG.info("    {}: {}", (Object)status.getComponentId(), (Object)status.getStatusMessage());
            }
        }
    }

    private void logWarnings(@Nonnull String itemId, @Nonnull @NonnullElements List<WarningStatus> statuses) {
        if (!statuses.isEmpty() && LOG.isWarnEnabled()) {
            LOG.warn("Item {} was marked with the following Warning status messages", (Object)itemId);
            for (WarningStatus status : statuses) {
                LOG.warn("    {}: {}", (Object)status.getComponentId(), (Object)status.getStatusMessage());
            }
        }
    }

    private void logErrors(@Nonnull String itemId, @Nonnull @NonnullElements List<ErrorStatus> statuses) {
        if (!statuses.isEmpty() && LOG.isErrorEnabled()) {
            LOG.error("Item {} was marked with the following Error status messages", (Object)itemId);
            for (ErrorStatus status : statuses) {
                LOG.error("    {}: {}", (Object)status.getComponentId(), (Object)status.getStatusMessage());
            }
        }
    }
}

