/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.metadata.pipeline;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.function.Predicate;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;
import net.shibboleth.metadata.CollectionMergeStrategy;
import net.shibboleth.metadata.Item;
import net.shibboleth.metadata.SimpleCollectionMergeStrategy;
import net.shibboleth.metadata.SimpleItemCollectionFactory;
import net.shibboleth.metadata.pipeline.AbstractStage;
import net.shibboleth.metadata.pipeline.Pipeline;
import net.shibboleth.metadata.pipeline.StageProcessingException;
import net.shibboleth.metadata.pipeline.impl.DirectExecutor;
import net.shibboleth.metadata.pipeline.impl.FutureSupport;
import net.shibboleth.metadata.pipeline.impl.PipelineCallable;
import net.shibboleth.shared.annotation.constraint.NonnullElements;
import net.shibboleth.shared.component.ComponentInitializationException;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.LoggerFactory;
import org.slf4j.Logger;

@ThreadSafe
public class SplitMergeStage<T>
extends AbstractStage<T> {
    @Nonnull
    private static final Logger LOG = LoggerFactory.getLogger(SplitMergeStage.class);
    @Nonnull
    @GuardedBy(value="this")
    private Executor executor = new DirectExecutor();
    @Nonnull
    @GuardedBy(value="this")
    private Supplier<List<Item<T>>> collectionFactory = new SimpleItemCollectionFactory();
    @Nonnull
    @GuardedBy(value="this")
    private Predicate<Item<T>> selectionStrategy = x -> false;
    @Nullable
    @GuardedBy(value="this")
    private Pipeline<T> selectedItemPipeline;
    @Nullable
    @GuardedBy(value="this")
    private Pipeline<T> nonselectedItemPipeline;
    @Nonnull
    @GuardedBy(value="this")
    private CollectionMergeStrategy mergeStrategy = new SimpleCollectionMergeStrategy();

    @Nonnull
    public final synchronized Executor getExecutor() {
        return this.executor;
    }

    public synchronized void setExecutor(@Nonnull Executor exec) {
        this.checkSetterPreconditions();
        this.executor = (Executor)Constraint.isNotNull((Object)exec, (String)"executor can not be null");
    }

    @Nonnull
    public final synchronized Supplier<List<Item<T>>> getCollectionFactory() {
        return this.collectionFactory;
    }

    public synchronized void setCollectionFactory(@Nonnull Supplier<List<Item<T>>> factory) {
        this.checkSetterPreconditions();
        this.collectionFactory = (Supplier)Constraint.isNotNull(factory, (String)"Collection factory can not be null");
    }

    @Nonnull
    public final synchronized Predicate<Item<T>> getSelectionStrategy() {
        return this.selectionStrategy;
    }

    public synchronized void setSelectionStrategy(@Nonnull Predicate<Item<T>> strategy) {
        this.checkSetterPreconditions();
        this.selectionStrategy = (Predicate)Constraint.isNotNull(strategy, (String)"Item selection strategy can not be null");
    }

    @Nullable
    public final synchronized Pipeline<T> getSelectedItemPipeline() {
        return this.selectedItemPipeline;
    }

    public synchronized void setSelectedItemPipeline(@Nullable Pipeline<T> pipeline) {
        this.checkSetterPreconditions();
        this.selectedItemPipeline = pipeline;
    }

    @Nullable
    public final synchronized Pipeline<T> getNonselectedItemPipeline() {
        return this.nonselectedItemPipeline;
    }

    public synchronized void setNonselectedItemPipeline(@Nullable Pipeline<T> pipeline) {
        this.checkSetterPreconditions();
        this.nonselectedItemPipeline = pipeline;
    }

    @Nonnull
    public final synchronized CollectionMergeStrategy getCollectionMergeStrategy() {
        return this.mergeStrategy;
    }

    public synchronized void setCollectionMergeStrategy(@Nonnull CollectionMergeStrategy strategy) {
        this.checkSetterPreconditions();
        this.mergeStrategy = (CollectionMergeStrategy)Constraint.isNotNull((Object)strategy, (String)"Collection merge strategy can not be null");
    }

    @Override
    protected void doExecute(@Nonnull @NonnullElements List<Item<T>> items) throws StageProcessingException {
        List<Item<T>> selectedItems = this.getCollectionFactory().get();
        assert (selectedItems != null);
        List<Item<T>> nonselectedItems = this.getCollectionFactory().get();
        assert (nonselectedItems != null);
        Predicate<Item<Item<T>>> strategy = this.getSelectionStrategy();
        for (Item<T> item : items) {
            if (strategy.test(item)) {
                selectedItems.add(item);
                continue;
            }
            nonselectedItems.add(item);
        }
        Future<List<Item<T>>> selectedItemFuture = this.executePipeline(this.getSelectedItemPipeline(), selectedItems);
        Future<List<Item<T>>> nonselectedItemFuture = this.executePipeline(this.getNonselectedItemPipeline(), nonselectedItems);
        ArrayList pipelineResults = new ArrayList();
        pipelineResults.add(FutureSupport.futureItems(selectedItemFuture));
        pipelineResults.add(FutureSupport.futureItems(nonselectedItemFuture));
        items.clear();
        this.getCollectionMergeStrategy().merge(items, pipelineResults);
    }

    @Nonnull
    private Future<List<Item<T>>> executePipeline(@Nullable Pipeline<T> pipeline, @Nonnull List<Item<T>> items) {
        if (pipeline == null) {
            CompletableFuture<List<Item<T>>> future = CompletableFuture.completedFuture(items);
            assert (future != null);
            return future;
        }
        PipelineCallable<T> callable = new PipelineCallable<T>(pipeline, items);
        FutureTask<List<Item<T>>> future = new FutureTask<List<Item<T>>>(callable);
        this.getExecutor().execute(future);
        return future;
    }

    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        if (this.selectedItemPipeline == null && this.nonselectedItemPipeline == null) {
            throw new ComponentInitializationException(this.getId() + " selected and non-selected pipelines are null");
        }
        if (this.selectedItemPipeline != null && !this.selectedItemPipeline.isInitialized()) {
            LOG.debug("Selected item pipeline was not initialized, initializing it now.");
            assert (this.selectedItemPipeline != null);
            this.selectedItemPipeline.initialize();
        }
        if (this.nonselectedItemPipeline != null && !this.nonselectedItemPipeline.isInitialized()) {
            LOG.debug("Non-selected item pipeline was not initialized, initializing it now.");
            assert (this.nonselectedItemPipeline != null);
            this.nonselectedItemPipeline.initialize();
        }
    }
}

