/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.metadata.dom.saml.shibboleth;

import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;
import javax.xml.namespace.QName;
import net.shibboleth.metadata.Item;
import net.shibboleth.metadata.dom.AbstractDOMValidationStage;
import net.shibboleth.metadata.dom.DOMTraversalContext;
import net.shibboleth.metadata.dom.SimpleDOMTraversalContext;
import net.shibboleth.metadata.dom.saml.shibboleth.ShibbolethMetadataSupport;
import net.shibboleth.metadata.pipeline.StageProcessingException;
import net.shibboleth.metadata.validate.Validator;
import net.shibboleth.metadata.validate.ValidatorSequence;
import net.shibboleth.shared.component.ComponentInitializationException;
import net.shibboleth.shared.xml.AttributeSupport;
import net.shibboleth.shared.xml.ElementSupport;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;

@ThreadSafe
public class ScopeValidationStage
extends AbstractDOMValidationStage<String, DOMTraversalContext> {
    @Nonnull
    @GuardedBy(value="this")
    private ValidatorSequence<String> regexpValidators = new ValidatorSequence();

    public synchronized void setRegexpValidators(@Nonnull List<Validator<String>> newValidators) {
        this.regexpValidators.setValidators(newValidators);
    }

    @Nonnull
    public synchronized List<Validator<String>> getRegexpValidators() {
        return this.regexpValidators.getValidators();
    }

    @Override
    @Nonnull
    protected DOMTraversalContext buildContext(@Nonnull Item<Element> item) {
        return new SimpleDOMTraversalContext(item);
    }

    @Override
    protected boolean applicable(@Nonnull Element element, @Nonnull DOMTraversalContext context) {
        return ElementSupport.isElementNamed((Element)element, (QName)ShibbolethMetadataSupport.SCOPE_NAME);
    }

    private boolean evaluateRegexpAttribute(@Nonnull Element element) {
        Attr attr = AttributeSupport.getAttribute((Element)element, (QName)ShibbolethMetadataSupport.REGEXP_ATTRIB_NAME);
        if (attr == null) {
            return false;
        }
        Boolean isRegexp = AttributeSupport.getAttributeValueAsBoolean((Attr)attr);
        if (isRegexp == null) {
            return false;
        }
        return isRegexp;
    }

    @Override
    protected void visit(@Nonnull Element element, @Nonnull DOMTraversalContext context) throws StageProcessingException {
        String text = element.getTextContent();
        assert (text != null);
        if (!this.evaluateRegexpAttribute(element)) {
            this.applyValidators(text, context);
        } else {
            this.regexpValidators.validate(text, context.getItem(), this.ensureId());
        }
    }

    @Override
    protected void doDestroy() {
        this.regexpValidators.destroy();
        super.doDestroy();
    }

    @Override
    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        this.regexpValidators.setId(this.ensureId());
        this.regexpValidators.initialize();
    }
}

