/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.metadata.dom.saml.mdrpi;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;
import net.shibboleth.metadata.FirstItemIdItemIdentificationStrategy;
import net.shibboleth.metadata.Item;
import net.shibboleth.metadata.dom.saml.mdrpi.RegistrationAuthority;
import net.shibboleth.shared.annotation.constraint.NonnullElements;
import net.shibboleth.shared.annotation.constraint.Unmodifiable;
import net.shibboleth.shared.collection.CollectionSupport;

@ThreadSafe
public class RegistrationAuthorityItemIdentificationStrategy<T>
extends FirstItemIdItemIdentificationStrategy<T> {
    @Nonnull
    @NonnullElements
    @Unmodifiable
    @GuardedBy(value="this")
    private Set<String> ignoredRegistrationAuthorities = CollectionSupport.emptySet();
    @Nonnull
    @NonnullElements
    @Unmodifiable
    @GuardedBy(value="this")
    private Map<String, String> registrationAuthorityDisplayNames = CollectionSupport.emptyMap();

    @Nonnull
    @NonnullElements
    @Unmodifiable
    public final synchronized Collection<String> getIgnoredRegistrationAuthorities() {
        return this.ignoredRegistrationAuthorities;
    }

    public synchronized void setIgnoredRegistrationAuthorities(@Nonnull @NonnullElements @Unmodifiable Collection<String> registrars) {
        this.ignoredRegistrationAuthorities = CollectionSupport.copyToSet(registrars);
    }

    @Nonnull
    @NonnullElements
    @Unmodifiable
    public final synchronized Map<String, String> getRegistrationAuthorityDisplayNames() {
        return this.registrationAuthorityDisplayNames;
    }

    public synchronized void setRegistrationAuthorityDisplayNames(@Nonnull @NonnullElements @Unmodifiable Map<String, String> names) {
        this.registrationAuthorityDisplayNames = CollectionSupport.copyToMap(names);
    }

    @Override
    @Nullable
    protected String getExtraIdentifier(@Nonnull Item<T> item) {
        List regAuths = item.getItemMetadata().get(RegistrationAuthority.class);
        if (regAuths.isEmpty()) {
            return null;
        }
        String regAuth = ((RegistrationAuthority)regAuths.get(0)).getRegistrationAuthority();
        if (this.getIgnoredRegistrationAuthorities().contains(regAuth)) {
            return null;
        }
        String displayName = this.getRegistrationAuthorityDisplayNames().get(regAuth);
        if (displayName != null) {
            return displayName;
        }
        return regAuth;
    }
}

