/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.metadata.dom.saml;

import java.time.Duration;
import java.time.Instant;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;
import javax.xml.namespace.QName;
import net.shibboleth.metadata.ErrorStatus;
import net.shibboleth.metadata.Item;
import net.shibboleth.metadata.dom.saml.SAMLMetadataSupport;
import net.shibboleth.metadata.pipeline.AbstractIteratingStage;
import net.shibboleth.metadata.pipeline.StageProcessingException;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.xml.AttributeSupport;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;

@ThreadSafe
public class ValidateValidUntilStage
extends AbstractIteratingStage<Element> {
    @GuardedBy(value="this")
    private boolean requireValidUntil = true;
    @Nonnull
    @GuardedBy(value="this")
    private Duration maxValidityInterval;

    public ValidateValidUntilStage() {
        Duration dur = Duration.ofDays(7L);
        assert (dur != null);
        this.maxValidityInterval = dur;
    }

    public final synchronized boolean isRequireValidUntil() {
        return this.requireValidUntil;
    }

    public synchronized void setRequireValidUntil(boolean isRequired) {
        this.checkSetterPreconditions();
        this.requireValidUntil = isRequired;
    }

    @Nonnull
    public final synchronized Duration getMaxValidityInterval() {
        return this.maxValidityInterval;
    }

    public synchronized void setMaxValidityInterval(@Nonnull Duration interval) {
        this.checkSetterPreconditions();
        Constraint.isNotNull((Object)interval, (String)"max validity interval can not be null");
        Constraint.isFalse((boolean)interval.isNegative(), (String)"max validity interval can not be negative");
        this.maxValidityInterval = interval;
    }

    @Override
    protected void doExecute(@Nonnull Item<Element> item) throws StageProcessingException {
        Element element = item.unwrap();
        if (!SAMLMetadataSupport.isEntitiesDescriptor(element)) {
            return;
        }
        Attr attr = AttributeSupport.getAttribute((Element)element, (QName)SAMLMetadataSupport.VALID_UNTIL_ATTRIB_NAME);
        if (attr == null) {
            if (this.isRequireValidUntil()) {
                item.getItemMetadata().put((Object)new ErrorStatus(this.ensureId(), "Item does not include a validUntil attribute"));
            }
            return;
        }
        Instant validUntil = AttributeSupport.getDateTimeAttribute((Attr)attr);
        if (validUntil == null) {
            if (this.isRequireValidUntil()) {
                item.getItemMetadata().put((Object)new ErrorStatus(this.ensureId(), "Item does not include a validUntil attribute"));
            }
        } else {
            Instant upperBound;
            Instant lowerBound = Instant.now();
            if (validUntil.isBefore(lowerBound)) {
                item.getItemMetadata().put((Object)new ErrorStatus(this.ensureId(), "Item has a validUntil prior to the current time"));
            }
            if (!this.getMaxValidityInterval().isZero() && validUntil.isAfter(upperBound = lowerBound.plus(this.getMaxValidityInterval()))) {
                item.getItemMetadata().put((Object)new ErrorStatus(this.ensureId(), "Item has validUntil larger than the maximum validity interval"));
            }
        }
    }
}

