/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.metadata.dom.saml;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.ThreadSafe;
import net.shibboleth.metadata.dom.AbstractElementVisitingStage;
import net.shibboleth.metadata.dom.DOMTraversalContext;
import net.shibboleth.metadata.dom.saml.SAMLSupport;
import net.shibboleth.shared.xml.QNameSupport;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

@ThreadSafe
public class SAMLStringElementCheckingStage
extends AbstractElementVisitingStage {
    private static final Pattern ALL_WHITE_SPACE_PATTERN = Pattern.compile("^[ \\t\\r\\n\\x85\\u2028]*$");

    private static boolean match(@Nonnull Node visited) {
        String textContent = visited.getTextContent();
        Matcher matcher = ALL_WHITE_SPACE_PATTERN.matcher(textContent);
        return matcher.matches();
    }

    @Override
    @Nonnull
    protected String errorPrefix(@Nonnull Element element) {
        return SAMLSupport.errorPrefix(element);
    }

    @Override
    protected void visit(@Nonnull Element e, @Nonnull DOMTraversalContext context) {
        if (SAMLStringElementCheckingStage.match(e)) {
            StringBuilder b = new StringBuilder("element ");
            b.append(QNameSupport.getNodeQName((Node)e));
            b.append(" must contain at least one non-whitespace character");
            String message = b.toString();
            assert (message != null);
            this.addError(context.getItem(), e, message);
        }
    }
}

