/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.metadata.dom.saml;

import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;
import javax.xml.namespace.QName;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.xml.AttributeSupport;
import net.shibboleth.shared.xml.ElementSupport;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

@ThreadSafe
public final class SAMLMetadataSupport {
    @Nonnull
    public static final String MD_NS = "urn:oasis:names:tc:SAML:2.0:metadata";
    @Nonnull
    public static final String MD_PREFIX = "md";
    @Nonnull
    public static final QName ENTITIES_DESCRIPTOR_NAME = new QName("urn:oasis:names:tc:SAML:2.0:metadata", "EntitiesDescriptor", "md");
    @Nonnull
    public static final QName ENTITY_DESCRIPTOR_NAME = new QName("urn:oasis:names:tc:SAML:2.0:metadata", "EntityDescriptor", "md");
    @Nonnull
    public static final QName EXTENSIONS_NAME = new QName("urn:oasis:names:tc:SAML:2.0:metadata", "Extensions", "md");
    @Nonnull
    public static final QName VALID_UNTIL_ATTRIB_NAME = new QName("validUntil");
    @Nonnull
    public static final QName CACHE_DURATION_ATTRIB_NAME = new QName("cacheDuration");
    @Nonnull
    public static final QName ENTITYID_ATTRIB_NAME = new QName("entityID");
    @Nonnull
    public static final QName ROLE_DESCRIPTOR_NAME = new QName("urn:oasis:names:tc:SAML:2.0:metadata", "RoleDescriptor");
    @Nonnull
    public static final QName IDP_SSO_DESCRIPTOR_NAME = new QName("urn:oasis:names:tc:SAML:2.0:metadata", "IDPSSODescriptor");
    @Nonnull
    public static final QName SP_SSO_DESCRIPTOR_NAME = new QName("urn:oasis:names:tc:SAML:2.0:metadata", "SPSSODescriptor");
    @Nonnull
    public static final QName AUTHN_AUTHORITY_DESCRIPTOR_NAME = new QName("urn:oasis:names:tc:SAML:2.0:metadata", "AuthnAuthorityDescriptor");
    @Nonnull
    public static final QName ATTRIBUTE_AUTHORITY_DESCRIPTOR_NAME = new QName("urn:oasis:names:tc:SAML:2.0:metadata", "AttributeAuthorityDescriptor");
    @Nonnull
    public static final QName PDP_DESCRIPTOR_NAME = new QName("urn:oasis:names:tc:SAML:2.0:metadata", "PDPDescriptor");
    @Nonnull
    public static final QName ORGANIZATION_NAME = new QName("urn:oasis:names:tc:SAML:2.0:metadata", "Organization", "md");
    @Nonnull
    public static final QName ORGANIZATIONNAME_NAME = new QName("urn:oasis:names:tc:SAML:2.0:metadata", "OrganizationName", "md");
    @Nonnull
    public static final QName ORGANIZATIONDISPLAYNAME_NAME = new QName("urn:oasis:names:tc:SAML:2.0:metadata", "OrganizationDisplayName", "md");
    @Nonnull
    public static final QName ORGANIZATIONURL_NAME = new QName("urn:oasis:names:tc:SAML:2.0:metadata", "OrganizationURL", "md");

    private SAMLMetadataSupport() {
    }

    public static boolean isEntityOrEntitiesDescriptor(@Nonnull Element e) {
        return SAMLMetadataSupport.isEntitiesDescriptor(e) || SAMLMetadataSupport.isEntityDescriptor(e);
    }

    public static boolean isEntitiesDescriptor(@Nonnull Element e) {
        return ElementSupport.isElementNamed((Element)e, (QName)ENTITIES_DESCRIPTOR_NAME);
    }

    public static boolean isEntityDescriptor(@Nonnull Element e) {
        return ElementSupport.isElementNamed((Element)e, (QName)ENTITY_DESCRIPTOR_NAME);
    }

    @Nonnull
    public static List<Element> getDescriptorExtensionList(@Nonnull Element descriptor, @Nonnull QName extensionName) {
        Constraint.isNotNull((Object)descriptor, (String)"descriptor may not be null");
        Constraint.isNotNull((Object)extensionName, (String)"extension name may not be null");
        List extensions = ElementSupport.getChildElements((Node)descriptor, (QName)EXTENSIONS_NAME);
        if (extensions.isEmpty()) {
            return extensions;
        }
        Element exten = (Element)extensions.get(0);
        assert (exten != null);
        return ElementSupport.getChildElements((Node)exten, (QName)extensionName);
    }

    public static Element getDescriptorExtension(@Nonnull Element descriptor, @Nonnull QName extensionName) {
        List<Element> results = SAMLMetadataSupport.getDescriptorExtensionList(descriptor, extensionName);
        if (results.isEmpty()) {
            return null;
        }
        return results.get(0);
    }

    @Nullable
    public static String getEntityID(@Nonnull Element entity) {
        return AttributeSupport.getAttributeValue((Element)entity, (QName)ENTITYID_ATTRIB_NAME);
    }
}

