/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.metadata.dom.saml;

import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.ThreadSafe;
import net.shibboleth.metadata.Item;
import net.shibboleth.metadata.dom.saml.ContactPersonFilterStage;
import net.shibboleth.metadata.dom.saml.SAMLMetadataSupport;
import net.shibboleth.metadata.pipeline.AbstractIteratingStage;
import net.shibboleth.metadata.pipeline.StageProcessingException;
import net.shibboleth.shared.primitive.LoggerFactory;
import net.shibboleth.shared.xml.ElementSupport;
import org.slf4j.Logger;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

@ThreadSafe
public class RemoveOrganizationStage
extends AbstractIteratingStage<Element> {
    @Nonnull
    private static final Logger LOG = LoggerFactory.getLogger(ContactPersonFilterStage.class);

    @Override
    protected void doExecute(@Nonnull Item<Element> item) throws StageProcessingException {
        Element descriptor = item.unwrap();
        if (SAMLMetadataSupport.isEntitiesDescriptor(descriptor)) {
            this.processEntitiesDescriptor(descriptor);
        } else if (SAMLMetadataSupport.isEntityDescriptor(descriptor)) {
            this.processEntityDescriptor(descriptor);
        }
    }

    protected void processEntitiesDescriptor(@Nonnull Element entitiesDescriptor) {
        List children = ElementSupport.getChildElements((Node)entitiesDescriptor);
        for (Element child : children) {
            assert (child != null);
            if (SAMLMetadataSupport.isEntitiesDescriptor(child)) {
                this.processEntitiesDescriptor(child);
                continue;
            }
            if (!SAMLMetadataSupport.isEntityDescriptor(child)) continue;
            this.processEntityDescriptor(child);
        }
    }

    protected void processEntityDescriptor(@Nonnull Element entityDescriptor) {
        String entityId = SAMLMetadataSupport.getEntityID(entityDescriptor);
        List organizations = ElementSupport.getChildElementsByTagNameNS((Node)entityDescriptor, (String)"urn:oasis:names:tc:SAML:2.0:metadata", (String)"Organization");
        if (!organizations.isEmpty()) {
            LOG.debug("{} pipeline stage filtering Organization from EntityDescriptor {}", (Object)this.getId(), (Object)entityId);
            for (Element organization : organizations) {
                entityDescriptor.removeChild(organization);
            }
        }
    }
}

