/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.metadata.dom.saml;

import java.time.Duration;
import java.time.Instant;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;
import javax.xml.namespace.QName;
import net.shibboleth.metadata.Item;
import net.shibboleth.metadata.dom.saml.SAMLMetadataSupport;
import net.shibboleth.metadata.pipeline.AbstractIteratingStage;
import net.shibboleth.metadata.pipeline.StageProcessingException;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.xml.AttributeSupport;
import net.shibboleth.shared.xml.ElementSupport;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

@ThreadSafe
public class PullUpValidUntilStage
extends AbstractIteratingStage<Element> {
    @Nonnull
    @GuardedBy(value="this")
    private Duration minValidityDuration = Duration.ZERO;
    @Nonnull
    @GuardedBy(value="this")
    private Duration maxValidityDuration = Duration.ofMillis(Long.MAX_VALUE);

    @Nonnull
    public final synchronized Duration getMinimumValidityDuration() {
        return this.minValidityDuration;
    }

    public synchronized void setMinimumValidityDuration(@Nonnull Duration duration) {
        this.checkSetterPreconditions();
        if (duration.isNegative()) {
            Duration dur = Duration.ZERO;
            assert (dur != null);
            this.minValidityDuration = dur;
        } else {
            this.minValidityDuration = duration;
        }
    }

    @Nonnull
    public final synchronized Duration getMaximumValidityDuration() {
        return this.maxValidityDuration;
    }

    public synchronized void setMaximumValidityDuration(@Nonnull Duration duration) {
        this.checkSetterPreconditions();
        Constraint.isGreaterThan((long)0L, (long)duration.toMillis(), (String)"Maximum validity duration must be greater than 0");
        this.maxValidityDuration = duration;
    }

    @Override
    protected void doExecute(@Nonnull Item<Element> item) throws StageProcessingException {
        Element descriptor = item.unwrap();
        Instant nearestValidUntil = this.getNearestValidUntil(descriptor);
        this.setValidUntil(descriptor, nearestValidUntil);
    }

    @Nullable
    protected Instant getNearestValidUntil(@Nonnull Element descriptor) {
        Instant validUntil;
        Instant nearestValidUntil = null;
        if (!SAMLMetadataSupport.isEntityOrEntitiesDescriptor(descriptor)) {
            return nearestValidUntil;
        }
        List entitiesDescriptors = ElementSupport.getChildElements((Node)descriptor, (QName)SAMLMetadataSupport.ENTITIES_DESCRIPTOR_NAME);
        for (Object entitiesDescriptor : entitiesDescriptors) {
            assert (entitiesDescriptor != null);
            validUntil = this.getNearestValidUntil((Element)entitiesDescriptor);
            if (validUntil == null || nearestValidUntil != null && !validUntil.isBefore(nearestValidUntil)) continue;
            nearestValidUntil = validUntil;
        }
        List entityDescriptors = ElementSupport.getChildElements((Node)descriptor, (QName)SAMLMetadataSupport.ENTITY_DESCRIPTOR_NAME);
        for (Element entityDescriptor : entityDescriptors) {
            assert (entityDescriptor != null);
            validUntil = this.getNearestValidUntil(entityDescriptor);
            if (validUntil == null || nearestValidUntil != null && !validUntil.isBefore(nearestValidUntil)) continue;
            nearestValidUntil = validUntil;
        }
        Attr validUntilAttr = descriptor.getAttributeNodeNS(null, SAMLMetadataSupport.VALID_UNTIL_ATTRIB_NAME.getLocalPart());
        if (validUntilAttr != null) {
            validUntil = AttributeSupport.getDateTimeAttribute((Attr)validUntilAttr);
            if (validUntil != null && (nearestValidUntil == null || validUntil.isBefore(nearestValidUntil))) {
                nearestValidUntil = validUntil;
            }
            descriptor.removeAttributeNode(validUntilAttr);
        }
        return nearestValidUntil;
    }

    protected void setValidUntil(@Nonnull Element descriptor, @Nullable Instant validUntil) {
        if (validUntil == null) {
            return;
        }
        Instant now = Instant.now();
        Instant minValidUntil = now.plus(this.getMinimumValidityDuration());
        assert (minValidUntil != null);
        Instant maxValidUntil = now.plus(this.getMaximumValidityDuration());
        assert (maxValidUntil != null);
        Instant boundedValidUntil = validUntil.isBefore(minValidUntil) ? minValidUntil : (validUntil.isAfter(maxValidUntil) ? maxValidUntil : validUntil);
        AttributeSupport.appendDateTimeAttribute((Element)descriptor, (QName)SAMLMetadataSupport.VALID_UNTIL_ATTRIB_NAME, (Instant)boundedValidUntil);
    }
}

