/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.metadata.dom.saml;

import java.time.Duration;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;
import javax.xml.namespace.QName;
import net.shibboleth.metadata.Item;
import net.shibboleth.metadata.dom.saml.SAMLMetadataSupport;
import net.shibboleth.metadata.pipeline.AbstractIteratingStage;
import net.shibboleth.metadata.pipeline.StageProcessingException;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.xml.AttributeSupport;
import net.shibboleth.shared.xml.ElementSupport;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

@ThreadSafe
public class PullUpCacheDurationStage
extends AbstractIteratingStage<Element> {
    @Nonnull
    @GuardedBy(value="this")
    private Duration minCacheDuration = Duration.ZERO;
    @Nonnull
    @GuardedBy(value="this")
    private Duration maxCacheDuration = Duration.ofMillis(Long.MAX_VALUE);

    @Nonnull
    public final synchronized Duration getMinimumCacheDuration() {
        return this.minCacheDuration;
    }

    public synchronized void setMinimumCacheDuration(@Nonnull Duration duration) {
        this.checkSetterPreconditions();
        if (duration.isNegative()) {
            Duration dur = Duration.ZERO;
            assert (dur != null);
            this.minCacheDuration = dur;
        } else {
            this.minCacheDuration = duration;
        }
    }

    @Nonnull
    public final synchronized Duration getMaximumCacheDuration() {
        return this.maxCacheDuration;
    }

    public synchronized void setMaximumCacheDuration(Duration duration) {
        this.checkSetterPreconditions();
        Constraint.isGreaterThan((long)0L, (long)duration.toMillis(), (String)"Maximum cache duration must be greater than 0");
        this.maxCacheDuration = duration;
    }

    @Override
    protected void doExecute(@Nonnull Item<Element> item) throws StageProcessingException {
        Element descriptor = item.unwrap();
        Duration cacheDuration = this.getShortestCacheDuration(descriptor);
        this.setCacheDuration(descriptor, cacheDuration);
    }

    @Nullable
    protected Duration getShortestCacheDuration(@Nonnull Element descriptor) {
        Duration shortestCacheDuration = null;
        if (!SAMLMetadataSupport.isEntityOrEntitiesDescriptor(descriptor)) {
            return shortestCacheDuration;
        }
        Duration cacheDuration = null;
        List entitiesDescriptors = ElementSupport.getChildElements((Node)descriptor, (QName)SAMLMetadataSupport.ENTITIES_DESCRIPTOR_NAME);
        for (Object entitiesDescriptor : entitiesDescriptors) {
            assert (entitiesDescriptor != null);
            cacheDuration = this.getShortestCacheDuration((Element)entitiesDescriptor);
            if (cacheDuration == null || shortestCacheDuration != null && cacheDuration.compareTo(shortestCacheDuration) >= 0) continue;
            shortestCacheDuration = cacheDuration;
        }
        List entityDescriptors = ElementSupport.getChildElements((Node)descriptor, (QName)SAMLMetadataSupport.ENTITY_DESCRIPTOR_NAME);
        for (Element entityDescriptor : entityDescriptors) {
            assert (entityDescriptor != null);
            cacheDuration = this.getShortestCacheDuration(entityDescriptor);
            if (cacheDuration == null || shortestCacheDuration != null && cacheDuration.compareTo(shortestCacheDuration) >= 0) continue;
            shortestCacheDuration = cacheDuration;
        }
        Attr cacheDurationAttr = AttributeSupport.getAttribute((Element)descriptor, (QName)SAMLMetadataSupport.CACHE_DURATION_ATTRIB_NAME);
        if (cacheDurationAttr != null) {
            cacheDuration = AttributeSupport.getDurationAttributeValue((Attr)cacheDurationAttr);
            if (cacheDuration != null && (shortestCacheDuration == null || cacheDuration.compareTo(shortestCacheDuration) < 0)) {
                shortestCacheDuration = cacheDuration;
            }
            descriptor.removeAttributeNode(cacheDurationAttr);
        }
        return shortestCacheDuration;
    }

    protected void setCacheDuration(@Nonnull Element descriptor, @Nullable Duration cacheDuration) {
        if (cacheDuration == null || cacheDuration.isNegative() || cacheDuration.isZero()) {
            return;
        }
        if (cacheDuration.compareTo(this.getMinimumCacheDuration()) < 0) {
            AttributeSupport.appendDurationAttribute((Element)descriptor, (QName)SAMLMetadataSupport.CACHE_DURATION_ATTRIB_NAME, (Duration)this.getMinimumCacheDuration());
        } else if (cacheDuration.compareTo(this.getMaximumCacheDuration()) > 0) {
            AttributeSupport.appendDurationAttribute((Element)descriptor, (QName)SAMLMetadataSupport.CACHE_DURATION_ATTRIB_NAME, (Duration)this.getMaximumCacheDuration());
        } else {
            AttributeSupport.appendDurationAttribute((Element)descriptor, (QName)SAMLMetadataSupport.CACHE_DURATION_ATTRIB_NAME, (Duration)cacheDuration);
        }
    }
}

