/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.metadata.dom.saml;

import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;
import javax.xml.namespace.QName;
import net.shibboleth.metadata.Item;
import net.shibboleth.metadata.dom.DOMElementItem;
import net.shibboleth.metadata.dom.saml.SAMLMetadataSupport;
import net.shibboleth.metadata.pipeline.AbstractStage;
import net.shibboleth.metadata.pipeline.ItemOrderingStrategy;
import net.shibboleth.metadata.pipeline.StageProcessingException;
import net.shibboleth.metadata.pipeline.impl.NoOpItemOrderingStrategy;
import net.shibboleth.shared.annotation.constraint.NonnullElements;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.LoggerFactory;
import net.shibboleth.shared.primitive.StringSupport;
import net.shibboleth.shared.xml.AttributeSupport;
import net.shibboleth.shared.xml.ElementSupport;
import net.shibboleth.shared.xml.NamespaceSupport;
import org.slf4j.Logger;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

@ThreadSafe
public class EntitiesDescriptorAssemblerStage
extends AbstractStage<Element> {
    @Nonnull
    private static final QName NAME_ATTRIB_NAME = new QName("Name");
    @Nonnull
    private static final Logger LOG = LoggerFactory.getLogger(EntitiesDescriptorAssemblerStage.class);
    @GuardedBy(value="this")
    private boolean noChildrenAProcessingError = true;
    @Nonnull
    @GuardedBy(value="this")
    private ItemOrderingStrategy<Element> itemOrderingStrategy = new NoOpItemOrderingStrategy<Element>();
    @Nullable
    @GuardedBy(value="this")
    private String descriptorName;

    public final synchronized boolean isNoChildrenAProcessingError() {
        return this.noChildrenAProcessingError;
    }

    public synchronized void setNoChildrenAProcessingError(boolean isError) {
        this.checkSetterPreconditions();
        this.noChildrenAProcessingError = isError;
    }

    @Nonnull
    public final synchronized ItemOrderingStrategy<Element> getItemOrderingStrategy() {
        return this.itemOrderingStrategy;
    }

    public synchronized void setItemOrderingStrategy(@Nonnull ItemOrderingStrategy<Element> strategy) {
        this.checkSetterPreconditions();
        this.itemOrderingStrategy = (ItemOrderingStrategy)Constraint.isNotNull(strategy, (String)"Item ordering strategy can not be null");
    }

    @Nullable
    public final synchronized String getDescriptorName() {
        return this.descriptorName;
    }

    public synchronized void setDescriptorName(@Nullable String name) {
        this.checkSetterPreconditions();
        this.descriptorName = StringSupport.trimOrNull((String)name);
    }

    @Override
    protected void doExecute(@Nonnull @NonnullElements List<Item<Element>> items) throws StageProcessingException {
        if (items.isEmpty()) {
            if (this.isNoChildrenAProcessingError()) {
                throw new StageProcessingException("Unable to assemble EntitiesDescriptor from an empty collection");
            }
            LOG.debug("Unable to assemble EntitiesDescriptor from an empty collection");
            return;
        }
        DOMImplementation domImpl = items.iterator().next().unwrap().getOwnerDocument().getImplementation();
        Document entitiesDescriptorDocument = domImpl.createDocument(null, null, null);
        assert (entitiesDescriptorDocument != null);
        Element entitiesDescriptor = ElementSupport.constructElement((Document)entitiesDescriptorDocument, (QName)SAMLMetadataSupport.ENTITIES_DESCRIPTOR_NAME);
        NamespaceSupport.appendNamespaceDeclaration((Element)entitiesDescriptor, (String)"urn:oasis:names:tc:SAML:2.0:metadata", (String)"md");
        entitiesDescriptorDocument.appendChild(entitiesDescriptor);
        this.addDescriptorName(entitiesDescriptor);
        ElementSupport.appendTextContent((Element)entitiesDescriptor, (String)"\n");
        List<Item<Element>> orderedItems = this.getItemOrderingStrategy().order(items);
        for (Item<Element> item : orderedItems) {
            Element descriptor = item.unwrap();
            if (!SAMLMetadataSupport.isEntityOrEntitiesDescriptor(descriptor)) continue;
            descriptor = (Element)entitiesDescriptorDocument.importNode(descriptor, true);
            entitiesDescriptor.appendChild(descriptor);
            ElementSupport.appendTextContent((Element)entitiesDescriptor, (String)"\n");
        }
        DOMElementItem item = new DOMElementItem(entitiesDescriptorDocument);
        items.clear();
        items.add(item);
    }

    protected void addDescriptorName(@Nonnull Element entitiesDescriptor) {
        String name = this.getDescriptorName();
        if (name != null) {
            AttributeSupport.appendAttribute((Element)entitiesDescriptor, (QName)NAME_ATTRIB_NAME, (String)name);
        }
    }
}

