/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.metadata.dom;

import java.util.Iterator;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;
import javax.xml.namespace.NamespaceContext;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import net.shibboleth.metadata.Item;
import net.shibboleth.metadata.dom.SimpleNamespaceContext;
import net.shibboleth.metadata.pipeline.AbstractStage;
import net.shibboleth.metadata.pipeline.StageProcessingException;
import net.shibboleth.shared.annotation.constraint.NonnullAfterInit;
import net.shibboleth.shared.annotation.constraint.NonnullElements;
import net.shibboleth.shared.annotation.constraint.NotEmpty;
import net.shibboleth.shared.component.ComponentInitializationException;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.LoggerFactory;
import net.shibboleth.shared.primitive.StringSupport;
import org.slf4j.Logger;
import org.w3c.dom.Element;

@ThreadSafe
public class XPathFilteringStage
extends AbstractStage<Element> {
    @Nonnull
    private static final Logger LOG = LoggerFactory.getLogger(XPathFilteringStage.class);
    @NonnullAfterInit
    @NotEmpty
    @GuardedBy(value="this")
    private String xpathExpression;
    @Nonnull
    @GuardedBy(value="this")
    private NamespaceContext namespaceContext = new SimpleNamespaceContext();

    @NonnullAfterInit
    @NotEmpty
    public final synchronized String getXPathExpression() {
        return this.xpathExpression;
    }

    public synchronized void setXPathExpression(@Nonnull @NotEmpty String expression) {
        this.checkSetterPreconditions();
        this.xpathExpression = (String)Constraint.isNotNull((Object)StringSupport.trimOrNull((String)expression), (String)"XPath expression can not be null or empty");
    }

    @Nonnull
    public final synchronized NamespaceContext getNamespaceContext() {
        return this.namespaceContext;
    }

    public synchronized void setNamespaceContext(@Nullable NamespaceContext context) {
        this.checkSetterPreconditions();
        this.namespaceContext = context == null ? new SimpleNamespaceContext() : context;
    }

    @Override
    public void doExecute(@Nonnull @NonnullElements List<Item<Element>> metadataCollection) throws StageProcessingException {
        XPathExpression compiledExpression;
        XPathFactory factory = XPathFactory.newInstance();
        XPath xpath = factory.newXPath();
        xpath.setNamespaceContext(this.getNamespaceContext());
        try {
            compiledExpression = xpath.compile(this.getXPathExpression());
        }
        catch (XPathExpressionException e) {
            throw new StageProcessingException("error compiling XPath expression", e);
        }
        Iterator<Item<Element>> iterator = metadataCollection.iterator();
        while (iterator.hasNext()) {
            Item<Element> item = iterator.next();
            try {
                if (!compiledExpression.evaluateExpression(item.unwrap(), Boolean.class).booleanValue()) continue;
                LOG.debug("removing item matching XPath condition");
                iterator.remove();
            }
            catch (XPathExpressionException e) {
                throw new StageProcessingException("error evaluating XPath expression", e);
            }
        }
    }

    protected synchronized void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        if (this.xpathExpression == null) {
            throw new ComponentInitializationException("XPath expression can not be null or empty");
        }
        XPathFactory factory = XPathFactory.newInstance();
        XPath xpath = factory.newXPath();
        xpath.setNamespaceContext(this.namespaceContext);
        try {
            xpath.compile(this.xpathExpression);
        }
        catch (XPathExpressionException e) {
            throw new ComponentInitializationException("error compiling XPath expression", (Exception)e);
        }
    }
}

