/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.metadata.dom;

import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.X509CRL;
import java.security.cert.X509Certificate;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;
import javax.xml.namespace.QName;
import net.shibboleth.metadata.Item;
import net.shibboleth.metadata.dom.impl.XMLSignatureSigner;
import net.shibboleth.metadata.pipeline.AbstractStage;
import net.shibboleth.metadata.pipeline.StageProcessingException;
import net.shibboleth.shared.annotation.constraint.NonnullAfterInit;
import net.shibboleth.shared.annotation.constraint.NonnullElements;
import net.shibboleth.shared.annotation.constraint.Unmodifiable;
import net.shibboleth.shared.collection.CollectionSupport;
import net.shibboleth.shared.component.ComponentInitializationException;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.LoggerFactory;
import org.apache.xml.security.Init;
import org.slf4j.Logger;
import org.w3c.dom.Element;

@ThreadSafe
public class XMLSignatureSigningStage
extends AbstractStage<Element> {
    @Nonnull
    private static final Logger LOG = LoggerFactory.getLogger(XMLSignatureSigningStage.class);
    @Nonnull
    @GuardedBy(value="this")
    private SHAVariant shaVariant = SHAVariant.SHA256;
    @NonnullAfterInit
    @GuardedBy(value="this")
    private PrivateKey privKey;
    @Nullable
    @GuardedBy(value="this")
    private PublicKey publicKey;
    @Nonnull
    @NonnullElements
    @Unmodifiable
    @GuardedBy(value="this")
    private List<X509Certificate> certificates = CollectionSupport.emptyList();
    @Nonnull
    @NonnullElements
    @Unmodifiable
    @GuardedBy(value="this")
    private List<X509CRL> crls = CollectionSupport.emptyList();
    @GuardedBy(value="this")
    private boolean c14nExclusive = true;
    @GuardedBy(value="this")
    private boolean c14nWithComments;
    @GuardedBy(value="this")
    private boolean removingCRsFromSignature = true;
    @Nonnull
    @NonnullElements
    @Unmodifiable
    @GuardedBy(value="this")
    private List<String> inclusivePrefixList = CollectionSupport.emptyList();
    @Nonnull
    @NonnullElements
    @Unmodifiable
    @GuardedBy(value="this")
    private List<QName> idAttributeNames = CollectionSupport.listOf((Object[])new QName[]{new QName("ID"), new QName("id"), new QName("Id")});
    @Nonnull
    @NonnullElements
    @Unmodifiable
    @GuardedBy(value="this")
    private List<String> keyNames = CollectionSupport.emptyList();
    @GuardedBy(value="this")
    private boolean includeKeyNames = true;
    @GuardedBy(value="this")
    private boolean includeKeyValue;
    @GuardedBy(value="this")
    private boolean includeX509SubjectName;
    @GuardedBy(value="this")
    private boolean includeX509Certificates = true;
    @GuardedBy(value="this")
    private boolean includeX509Crls;
    @GuardedBy(value="this")
    private boolean includeX509IssuerSerial;
    @GuardedBy(value="this")
    private boolean debugPreDigest;

    @Nonnull
    public final synchronized SHAVariant getSHAVariant() {
        return this.shaVariant;
    }

    public synchronized void setSHAVariant(@Nonnull SHAVariant variant) {
        this.checkSetterPreconditions();
        this.shaVariant = (SHAVariant)((Object)Constraint.isNotNull((Object)((Object)variant), (String)"SHA variant can not be null"));
    }

    @Nullable
    public final synchronized PrivateKey getPrivateKey() {
        return this.privKey;
    }

    public synchronized void setPrivateKey(@Nonnull PrivateKey key) {
        this.checkSetterPreconditions();
        this.privKey = (PrivateKey)Constraint.isNotNull((Object)key, (String)"Private key can not be null");
    }

    @Nullable
    public final synchronized PublicKey getPublicKey() {
        return this.publicKey;
    }

    public synchronized void setPublicKey(@Nullable PublicKey key) {
        this.checkSetterPreconditions();
        this.publicKey = key;
    }

    @Nonnull
    @NonnullElements
    @Unmodifiable
    public final synchronized List<X509Certificate> getCertificates() {
        return this.certificates;
    }

    public synchronized void setCertificates(@Nonnull @NonnullElements @Unmodifiable List<X509Certificate> certs) {
        this.checkSetterPreconditions();
        this.certificates = CollectionSupport.copyToList(certs);
    }

    @Nonnull
    @NonnullElements
    @Unmodifiable
    public final synchronized List<X509CRL> getCrls() {
        return this.crls;
    }

    public synchronized void setCrls(@Nonnull @NonnullElements @Unmodifiable List<X509CRL> revocationLists) {
        this.checkSetterPreconditions();
        this.crls = CollectionSupport.copyToList(revocationLists);
    }

    public final synchronized boolean isC14nExclusive() {
        return this.c14nExclusive;
    }

    public synchronized void setC14nExclusive(boolean isExclusive) {
        this.checkSetterPreconditions();
        this.c14nExclusive = isExclusive;
    }

    public final synchronized boolean isC14nWithComments() {
        return this.c14nWithComments;
    }

    public synchronized void setC14nWithComments(boolean withComments) {
        this.checkSetterPreconditions();
        this.c14nWithComments = withComments;
    }

    @Nonnull
    @NonnullElements
    @Unmodifiable
    public final synchronized List<String> getInclusivePrefixList() {
        return this.inclusivePrefixList;
    }

    public synchronized void setInclusivePrefixList(@Nonnull @NonnullElements @Unmodifiable List<String> prefixList) {
        this.checkSetterPreconditions();
        this.inclusivePrefixList = CollectionSupport.copyToList(prefixList);
    }

    @Nonnull
    @NonnullElements
    @Unmodifiable
    public final synchronized List<QName> getIdAttributeNames() {
        return this.idAttributeNames;
    }

    public synchronized void setIdAttributeNames(@Nonnull @NonnullElements @Unmodifiable List<QName> names) {
        this.checkSetterPreconditions();
        Constraint.isNotNull(names, (String)"names property may not be null");
        this.idAttributeNames = CollectionSupport.copyToList(names);
    }

    @Nonnull
    @NonnullElements
    @Unmodifiable
    public final synchronized List<String> getKeyNames() {
        return this.keyNames;
    }

    public synchronized void setKeyNames(@Nonnull @NonnullElements @Unmodifiable List<String> names) {
        this.checkSetterPreconditions();
        this.keyNames = CollectionSupport.copyToList(names);
    }

    public final synchronized boolean isIncludeKeyNames() {
        return this.includeKeyNames;
    }

    public synchronized void setIncludeKeyNames(boolean include) {
        this.checkSetterPreconditions();
        this.includeKeyNames = include;
    }

    public final synchronized boolean isIncludeKeyValue() {
        return this.includeKeyValue;
    }

    public synchronized void setIncludeKeyValue(boolean included) {
        this.checkSetterPreconditions();
        this.includeKeyValue = included;
    }

    public final synchronized boolean isIncludeX509SubjectName() {
        return this.includeX509SubjectName;
    }

    public synchronized void setIncludeX509SubjectName(boolean include) {
        this.checkSetterPreconditions();
        this.includeX509SubjectName = include;
    }

    public final synchronized boolean isIncludeX509Certificates() {
        return this.includeX509Certificates;
    }

    public synchronized void setIncludeX509Certificates(boolean include) {
        this.checkSetterPreconditions();
        this.includeX509Certificates = include;
    }

    public final synchronized boolean isIncludeX509Crls() {
        return this.includeX509Crls;
    }

    public synchronized void setIncludeX509Crls(boolean include) {
        this.checkSetterPreconditions();
        this.includeX509Crls = include;
    }

    public final synchronized boolean isIncludeX509IssuerSerial() {
        return this.includeX509IssuerSerial;
    }

    public synchronized void setIncludeX509IssuerSerial(boolean include) {
        this.checkSetterPreconditions();
        this.includeX509IssuerSerial = include;
    }

    public final synchronized boolean isDebugPreDigest() {
        return this.debugPreDigest;
    }

    public synchronized void setDebugPreDigest(boolean debug) {
        this.checkSetterPreconditions();
        this.debugPreDigest = debug;
    }

    public final synchronized boolean isRemovingCRsFromSignature() {
        return this.removingCRsFromSignature;
    }

    public final synchronized void setRemovingCRsFromSignature(boolean newValue) {
        this.checkSetterPreconditions();
        this.removingCRsFromSignature = newValue;
    }

    @Override
    protected void doExecute(@Nonnull @NonnullElements List<Item<Element>> items) throws StageProcessingException {
        XMLSignatureSigner signer = new XMLSignatureSigner(this, LOG);
        for (Item<Element> item : items) {
            assert (item != null);
            signer.sign(item);
        }
    }

    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        Init.init();
    }

    public static enum SHAVariant {
        SHA1,
        SHA256,
        SHA384,
        SHA512;

    }
}

