/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.metadata.dom;

import java.util.ArrayList;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;
import net.shibboleth.metadata.Item;
import net.shibboleth.metadata.pipeline.AbstractIteratingStage;
import net.shibboleth.shared.annotation.constraint.NonnullAfterInit;
import net.shibboleth.shared.annotation.constraint.NotEmpty;
import net.shibboleth.shared.component.ComponentInitializationException;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.StringSupport;
import net.shibboleth.shared.xml.ElementSupport;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

@ThreadSafe
public class EmptyContainerStrippingStage
extends AbstractIteratingStage<Element> {
    @NonnullAfterInit
    @NotEmpty
    @GuardedBy(value="this")
    private String elementNamespace;
    @NonnullAfterInit
    @NotEmpty
    @GuardedBy(value="this")
    private String elementName;

    @Nullable
    public final synchronized String getElementNamespace() {
        return this.elementNamespace;
    }

    public synchronized void setElementNamespace(@Nonnull @NotEmpty String namespace) {
        this.checkSetterPreconditions();
        this.elementNamespace = (String)Constraint.isNotNull((Object)StringSupport.trimOrNull((String)namespace), (String)"target namespace can not be null or empty");
    }

    @Nullable
    public final synchronized String getElementName() {
        return this.elementName;
    }

    public synchronized void setElementName(@Nonnull @NotEmpty String name) {
        this.checkSetterPreconditions();
        this.elementName = (String)Constraint.isNotNull((Object)StringSupport.trimOrNull((String)name), (String)"target element name can not be null or empty");
    }

    private boolean hasChildElements(@Nonnull Element element) {
        Element firstChild = ElementSupport.getFirstChildElement((Node)element);
        return firstChild != null;
    }

    @Override
    protected void doExecute(@Nonnull Item<Element> item) {
        Element element = item.unwrap();
        NodeList extensionList = element.getElementsByTagNameNS(this.getElementNamespace(), this.getElementName());
        ArrayList<Element> containers = new ArrayList<Element>(extensionList.getLength());
        for (int eIndex = extensionList.getLength() - 1; eIndex >= 0; --eIndex) {
            containers.add((Element)extensionList.item(eIndex));
        }
        for (Element container : containers) {
            assert (container != null);
            if (this.hasChildElements(container)) continue;
            container.getParentNode().removeChild(container);
        }
    }

    protected synchronized void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        if (this.elementNamespace == null) {
            throw new ComponentInitializationException("target namespace can not be null or empty");
        }
        if (this.elementName == null) {
            throw new ComponentInitializationException("target element name can not be null or empty");
        }
    }
}

